/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.output;

import com.google.common.annotations.VisibleForTesting;
import fr.xephi.authme.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

final class LogFilterHelper {
    @VisibleForTesting
    static final List<String> COMMANDS_TO_SKIP = LogFilterHelper.withAndWithoutAuthMePrefix("/login ", "/l ", "/log ", "/register ", "/reg ", "/unregister ", "/unreg ", "/changepassword ", "/cp ", "/changepass ", "/authme register ", "/authme reg ", "/authme r ", "/authme changepassword ", "/authme password ", "/authme changepass ", "/authme cp ", "/email setpassword ");
    private static final String ISSUED_COMMAND_TEXT = "issued server command:";

    private LogFilterHelper() {
    }

    static boolean isSensitiveAuthMeCommand(String message) {
        if (message == null) {
            return false;
        }
        String lowerMessage = message.toLowerCase(Locale.ROOT);
        return lowerMessage.contains(ISSUED_COMMAND_TEXT) && StringUtils.containsAny(lowerMessage, COMMANDS_TO_SKIP);
    }

    private static List<String> withAndWithoutAuthMePrefix(String ... commands) {
        ArrayList<Object> commandList = new ArrayList<Object>(commands.length * 2);
        for (String command : commands) {
            commandList.add(command);
            commandList.add(command.substring(0, 1) + "authme:" + command.substring(1));
        }
        return Collections.unmodifiableList(commandList);
    }
}

