/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.output;

import fr.xephi.authme.output.LogFilterHelper;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;

public class Log4JFilter
extends AbstractFilter {
    private static final long serialVersionUID = -5594073755007974254L;

    private static Filter.Result validateMessage(Message message) {
        if (message == null) {
            return Filter.Result.NEUTRAL;
        }
        return Log4JFilter.validateMessage(message.getFormattedMessage());
    }

    private static Filter.Result validateMessage(String message) {
        return LogFilterHelper.isSensitiveAuthMeCommand(message) ? Filter.Result.DENY : Filter.Result.NEUTRAL;
    }

    public Filter.Result filter(LogEvent event) {
        Message candidate = null;
        if (event != null) {
            candidate = event.getMessage();
        }
        return Log4JFilter.validateMessage(candidate);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        return Log4JFilter.validateMessage(msg);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
        return Log4JFilter.validateMessage(msg);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        String candidate = null;
        if (msg != null) {
            candidate = msg.toString();
        }
        return Log4JFilter.validateMessage(candidate);
    }
}

