/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.message.updater;

import ch.jalu.configme.resource.PropertyReader;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import fr.xephi.authme.message.MessageKey;
import fr.xephi.authme.message.updater.MessageKeyConfigurationData;
import java.util.Map;

final class OldMessageKeysMigrater {
    @VisibleForTesting
    static final Map<MessageKey, String> KEYS_TO_OLD_PATH = ImmutableMap.builder().put((Object)MessageKey.LOGIN_SUCCESS, (Object)"login").put((Object)MessageKey.ERROR, (Object)"error").put((Object)MessageKey.DENIED_COMMAND, (Object)"denied_command").put((Object)MessageKey.SAME_IP_ONLINE, (Object)"same_ip_online").put((Object)MessageKey.DENIED_CHAT, (Object)"denied_chat").put((Object)MessageKey.KICK_ANTIBOT, (Object)"kick_antibot").put((Object)MessageKey.UNKNOWN_USER, (Object)"unknown_user").put((Object)MessageKey.NOT_LOGGED_IN, (Object)"not_logged_in").put((Object)MessageKey.USAGE_LOGIN, (Object)"usage_log").put((Object)MessageKey.WRONG_PASSWORD, (Object)"wrong_pwd").put((Object)MessageKey.UNREGISTERED_SUCCESS, (Object)"unregistered").put((Object)MessageKey.REGISTRATION_DISABLED, (Object)"reg_disabled").put((Object)MessageKey.SESSION_RECONNECTION, (Object)"valid_session").put((Object)MessageKey.ACCOUNT_NOT_ACTIVATED, (Object)"vb_nonActiv").put((Object)MessageKey.NAME_ALREADY_REGISTERED, (Object)"user_regged").put((Object)MessageKey.NO_PERMISSION, (Object)"no_perm").put((Object)MessageKey.LOGIN_MESSAGE, (Object)"login_msg").put((Object)MessageKey.REGISTER_MESSAGE, (Object)"reg_msg").put((Object)MessageKey.MAX_REGISTER_EXCEEDED, (Object)"max_reg").put((Object)MessageKey.USAGE_REGISTER, (Object)"usage_reg").put((Object)MessageKey.USAGE_UNREGISTER, (Object)"usage_unreg").put((Object)MessageKey.PASSWORD_CHANGED_SUCCESS, (Object)"pwd_changed").put((Object)MessageKey.PASSWORD_MATCH_ERROR, (Object)"password_error").put((Object)MessageKey.PASSWORD_IS_USERNAME_ERROR, (Object)"password_error_nick").put((Object)MessageKey.PASSWORD_UNSAFE_ERROR, (Object)"password_error_unsafe").put((Object)MessageKey.PASSWORD_CHARACTERS_ERROR, (Object)"password_error_chars").put((Object)MessageKey.SESSION_EXPIRED, (Object)"invalid_session").put((Object)MessageKey.MUST_REGISTER_MESSAGE, (Object)"reg_only").put((Object)MessageKey.ALREADY_LOGGED_IN_ERROR, (Object)"logged_in").put((Object)MessageKey.LOGOUT_SUCCESS, (Object)"logout").put((Object)MessageKey.USERNAME_ALREADY_ONLINE_ERROR, (Object)"same_nick").put((Object)MessageKey.REGISTER_SUCCESS, (Object)"registered").put((Object)MessageKey.INVALID_PASSWORD_LENGTH, (Object)"pass_len").put((Object)MessageKey.CONFIG_RELOAD_SUCCESS, (Object)"reload").put((Object)MessageKey.LOGIN_TIMEOUT_ERROR, (Object)"timeout").put((Object)MessageKey.USAGE_CHANGE_PASSWORD, (Object)"usage_changepassword").put((Object)MessageKey.INVALID_NAME_LENGTH, (Object)"name_len").put((Object)MessageKey.INVALID_NAME_CHARACTERS, (Object)"regex").put((Object)MessageKey.ADD_EMAIL_MESSAGE, (Object)"add_email").put((Object)MessageKey.FORGOT_PASSWORD_MESSAGE, (Object)"recovery_email").put((Object)MessageKey.USAGE_CAPTCHA, (Object)"usage_captcha").put((Object)MessageKey.CAPTCHA_WRONG_ERROR, (Object)"wrong_captcha").put((Object)MessageKey.CAPTCHA_SUCCESS, (Object)"valid_captcha").put((Object)MessageKey.CAPTCHA_FOR_REGISTRATION_REQUIRED, (Object)"captcha_for_registration").put((Object)MessageKey.REGISTER_CAPTCHA_SUCCESS, (Object)"register_captcha_valid").put((Object)MessageKey.KICK_FOR_VIP, (Object)"kick_forvip").put((Object)MessageKey.KICK_FULL_SERVER, (Object)"kick_fullserver").put((Object)MessageKey.USAGE_ADD_EMAIL, (Object)"usage_email_add").put((Object)MessageKey.USAGE_CHANGE_EMAIL, (Object)"usage_email_change").put((Object)MessageKey.USAGE_RECOVER_EMAIL, (Object)"usage_email_recovery").put((Object)MessageKey.INVALID_NEW_EMAIL, (Object)"new_email_invalid").put((Object)MessageKey.INVALID_OLD_EMAIL, (Object)"old_email_invalid").put((Object)MessageKey.INVALID_EMAIL, (Object)"email_invalid").put((Object)MessageKey.EMAIL_ADDED_SUCCESS, (Object)"email_added").put((Object)MessageKey.CONFIRM_EMAIL_MESSAGE, (Object)"email_confirm").put((Object)MessageKey.EMAIL_CHANGED_SUCCESS, (Object)"email_changed").put((Object)MessageKey.EMAIL_SHOW, (Object)"email_show").put((Object)MessageKey.SHOW_NO_EMAIL, (Object)"show_no_email").put((Object)MessageKey.RECOVERY_EMAIL_SENT_MESSAGE, (Object)"email_send").put((Object)MessageKey.COUNTRY_BANNED_ERROR, (Object)"country_banned").put((Object)MessageKey.ANTIBOT_AUTO_ENABLED_MESSAGE, (Object)"antibot_auto_enabled").put((Object)MessageKey.ANTIBOT_AUTO_DISABLED_MESSAGE, (Object)"antibot_auto_disabled").put((Object)MessageKey.EMAIL_ALREADY_USED_ERROR, (Object)"email_already_used").put((Object)MessageKey.TWO_FACTOR_CREATE, (Object)"two_factor_create").put((Object)MessageKey.NOT_OWNER_ERROR, (Object)"not_owner_error").put((Object)MessageKey.INVALID_NAME_CASE, (Object)"invalid_name_case").put((Object)MessageKey.TEMPBAN_MAX_LOGINS, (Object)"tempban_max_logins").put((Object)MessageKey.ACCOUNTS_OWNED_SELF, (Object)"accounts_owned_self").put((Object)MessageKey.ACCOUNTS_OWNED_OTHER, (Object)"accounts_owned_other").put((Object)MessageKey.KICK_FOR_ADMIN_REGISTER, (Object)"kicked_admin_registered").put((Object)MessageKey.INCOMPLETE_EMAIL_SETTINGS, (Object)"incomplete_email_settings").put((Object)MessageKey.EMAIL_SEND_FAILURE, (Object)"email_send_failure").put((Object)MessageKey.RECOVERY_CODE_SENT, (Object)"recovery_code_sent").put((Object)MessageKey.INCORRECT_RECOVERY_CODE, (Object)"recovery_code_incorrect").put((Object)MessageKey.RECOVERY_TRIES_EXCEEDED, (Object)"recovery_tries_exceeded").put((Object)MessageKey.RECOVERY_CODE_CORRECT, (Object)"recovery_code_correct").put((Object)MessageKey.RECOVERY_CHANGE_PASSWORD, (Object)"recovery_change_password").put((Object)MessageKey.CHANGE_PASSWORD_EXPIRED, (Object)"change_password_expired").put((Object)MessageKey.EMAIL_COOLDOWN_ERROR, (Object)"email_cooldown_error").put((Object)MessageKey.VERIFICATION_CODE_REQUIRED, (Object)"verification_code_required").put((Object)MessageKey.USAGE_VERIFICATION_CODE, (Object)"usage_verification_code").put((Object)MessageKey.INCORRECT_VERIFICATION_CODE, (Object)"incorrect_verification_code").put((Object)MessageKey.VERIFICATION_CODE_VERIFIED, (Object)"verification_code_verified").put((Object)MessageKey.VERIFICATION_CODE_ALREADY_VERIFIED, (Object)"verification_code_already_verified").put((Object)MessageKey.VERIFICATION_CODE_EXPIRED, (Object)"verification_code_expired").put((Object)MessageKey.VERIFICATION_CODE_EMAIL_NEEDED, (Object)"verification_code_email_needed").put((Object)MessageKey.SECOND, (Object)"second").put((Object)MessageKey.SECONDS, (Object)"seconds").put((Object)MessageKey.MINUTE, (Object)"minute").put((Object)MessageKey.MINUTES, (Object)"minutes").put((Object)MessageKey.HOUR, (Object)"hour").put((Object)MessageKey.HOURS, (Object)"hours").put((Object)MessageKey.DAY, (Object)"day").put((Object)MessageKey.DAYS, (Object)"days").build();
    private static final Map<MessageKey, Map<String, String>> PLACEHOLDER_REPLACEMENTS = ImmutableMap.builder().put((Object)MessageKey.PASSWORD_CHARACTERS_ERROR, (Object)ImmutableMap.of((Object)"REG_EX", (Object)"%valid_chars")).put((Object)MessageKey.INVALID_NAME_CHARACTERS, (Object)ImmutableMap.of((Object)"REG_EX", (Object)"%valid_chars")).put((Object)MessageKey.USAGE_CAPTCHA, (Object)ImmutableMap.of((Object)"<theCaptcha>", (Object)"%captcha_code")).put((Object)MessageKey.CAPTCHA_FOR_REGISTRATION_REQUIRED, (Object)ImmutableMap.of((Object)"<theCaptcha>", (Object)"%captcha_code")).put((Object)MessageKey.CAPTCHA_WRONG_ERROR, (Object)ImmutableMap.of((Object)"THE_CAPTCHA", (Object)"%captcha_code")).build();

    private OldMessageKeysMigrater() {
    }

    static boolean migrateOldPaths(PropertyReader reader, MessageKeyConfigurationData configurationData) {
        boolean wasPropertyMoved = false;
        for (Map.Entry<MessageKey, String> migrationEntry : KEYS_TO_OLD_PATH.entrySet()) {
            wasPropertyMoved |= OldMessageKeysMigrater.moveIfApplicable(reader, configurationData, migrationEntry.getKey(), migrationEntry.getValue());
        }
        return wasPropertyMoved;
    }

    private static boolean moveIfApplicable(PropertyReader reader, MessageKeyConfigurationData configurationData, MessageKey messageKey, String oldPath) {
        String textAtOldPath;
        if (configurationData.getMessage(messageKey) == null && (textAtOldPath = reader.getString(oldPath)) != null) {
            textAtOldPath = OldMessageKeysMigrater.replaceOldPlaceholders(messageKey, textAtOldPath);
            configurationData.setMessage(messageKey, textAtOldPath);
            return true;
        }
        return false;
    }

    private static String replaceOldPlaceholders(MessageKey key, String text) {
        Map<String, String> replacements = PLACEHOLDER_REPLACEMENTS.get((Object)key);
        if (replacements == null) {
            return text;
        }
        String newText = text;
        for (Map.Entry<String, String> replacement : replacements.entrySet()) {
            newText = newText.replace(replacement.getKey(), replacement.getValue());
        }
        return newText;
    }
}

