/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.message.updater;

import ch.jalu.configme.configurationdata.ConfigurationData;
import ch.jalu.configme.configurationdata.PropertyListBuilder;
import ch.jalu.configme.properties.Property;
import ch.jalu.configme.properties.StringProperty;
import ch.jalu.configme.properties.convertresult.ConvertErrorRecorder;
import ch.jalu.configme.resource.PropertyReader;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.message.MessageKey;
import fr.xephi.authme.message.updater.JarMessageSource;
import fr.xephi.authme.message.updater.MessageKeyConfigurationData;
import fr.xephi.authme.message.updater.MigraterYamlFileResource;
import fr.xephi.authme.message.updater.OldMessageKeysMigrater;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MessageUpdater {
    private ConsoleLogger logger = ConsoleLoggerFactory.get(MessageUpdater.class);

    public boolean migrateAndSave(File userFile, String localJarPath, String defaultJarPath) {
        JarMessageSource jarMessageSource = new JarMessageSource(localJarPath, defaultJarPath);
        return this.migrateAndSave(userFile, jarMessageSource);
    }

    private boolean migrateAndSave(File userFile, JarMessageSource jarMessageSource) {
        MessageKeyConfigurationData configurationData = MessageUpdater.createConfigurationData();
        MigraterYamlFileResource userResource = new MigraterYamlFileResource(userFile);
        PropertyReader reader = userResource.createReader();
        configurationData.initializeValues(reader);
        boolean movedOldKeys = this.migrateOldKeys(reader, configurationData);
        boolean movedNewerKeys = this.migrateKeys(reader, configurationData);
        boolean addedMissingKeys = this.addMissingKeys(jarMessageSource, configurationData);
        if (movedOldKeys || movedNewerKeys || addedMissingKeys) {
            MessageUpdater.backupMessagesFile(userFile);
            userResource.exportProperties((ConfigurationData)configurationData);
            this.logger.debug("Successfully saved {0}", (Object)userFile);
            return true;
        }
        return false;
    }

    private boolean migrateKeys(PropertyReader propertyReader, MessageKeyConfigurationData configurationData) {
        return MessageUpdater.moveIfApplicable(propertyReader, configurationData, "misc.two_factor_create", MessageKey.TWO_FACTOR_CREATE);
    }

    private static boolean moveIfApplicable(PropertyReader reader, MessageKeyConfigurationData configurationData, String oldPath, MessageKey messageKey) {
        if (configurationData.getMessage(messageKey) == null && reader.getString(oldPath) != null) {
            configurationData.setMessage(messageKey, reader.getString(oldPath));
            return true;
        }
        return false;
    }

    private boolean migrateOldKeys(PropertyReader propertyReader, MessageKeyConfigurationData configurationData) {
        boolean hasChange = OldMessageKeysMigrater.migrateOldPaths(propertyReader, configurationData);
        if (hasChange) {
            this.logger.info("Old keys have been moved to the new ones in your messages_xx.yml file");
        }
        return hasChange;
    }

    private boolean addMissingKeys(JarMessageSource jarMessageSource, MessageKeyConfigurationData configurationData) {
        ArrayList<String> addedKeys = new ArrayList<String>();
        for (Property<String> property : configurationData.getAllMessageProperties()) {
            String key = property.getPath();
            if (configurationData.getValue(property) != null) continue;
            configurationData.setValue(property, jarMessageSource.getMessageFromJar(property));
            addedKeys.add(key);
        }
        if (!addedKeys.isEmpty()) {
            this.logger.info("Added " + addedKeys.size() + " missing keys to your messages_xx.yml file: " + String.valueOf(addedKeys));
            return true;
        }
        return false;
    }

    private static void backupMessagesFile(File messagesFile) {
        String backupName = FileUtils.createBackupFilePath(messagesFile);
        File backupFile = new File(backupName);
        try {
            Files.copy((File)messagesFile, (File)backupFile);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not back up '" + String.valueOf(messagesFile) + "' to '" + String.valueOf(backupFile) + "'", e);
        }
    }

    public static MessageKeyConfigurationData createConfigurationData() {
        ImmutableMap comments = ImmutableMap.builder().put((Object)"registration", (Object)"Registration").put((Object)"password", (Object)"Password errors on registration").put((Object)"login", (Object)"Login").put((Object)"error", (Object)"Errors").put((Object)"antibot", (Object)"AntiBot").put((Object)"unregister", (Object)"Unregister").put((Object)"misc", (Object)"Other messages").put((Object)"session", (Object)"Session messages").put((Object)"on_join_validation", (Object)"Error messages when joining").put((Object)"email", (Object)"Email").put((Object)"recovery", (Object)"Password recovery by email").put((Object)"captcha", (Object)"Captcha").put((Object)"verification", (Object)"Verification code").put((Object)"time", (Object)"Time units").put((Object)"two_factor", (Object)"Two-factor authentication").build();
        HashSet<String> addedKeys = new HashSet<String>();
        MessageKeyPropertyListBuilder builder = new MessageKeyPropertyListBuilder();
        for (String path : comments.keySet()) {
            MessageKey key2 = Arrays.stream(MessageKey.values()).filter(p -> p.getKey().startsWith(path + ".")).findFirst().orElseThrow(() -> new IllegalStateException(path));
            builder.addMessageKey(key2);
            addedKeys.add(key2.getKey());
        }
        Arrays.stream(MessageKey.values()).filter(key -> !addedKeys.contains(key.getKey())).forEach(builder::addMessageKey);
        Map<String, List<String>> commentsMap = comments.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> Collections.singletonList((String)e.getValue())));
        return new MessageKeyConfigurationData(builder, commentsMap);
    }

    static final class MessageKeyPropertyListBuilder {
        private PropertyListBuilder propertyListBuilder = new PropertyListBuilder();

        MessageKeyPropertyListBuilder() {
        }

        void addMessageKey(MessageKey key) {
            this.propertyListBuilder.add((Property)new MessageKeyProperty(key));
        }

        List<MessageKeyProperty> getAllProperties() {
            return this.propertyListBuilder.create();
        }
    }

    static final class MessageKeyProperty
    extends StringProperty {
        MessageKeyProperty(MessageKey messageKey) {
            super(messageKey.getKey(), "");
        }

        protected String getFromReader(PropertyReader reader, ConvertErrorRecorder errorRecorder) {
            return reader.getString(this.getPath());
        }
    }
}

