/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.message.updater;

import ch.jalu.configme.exception.ConfigMeException;
import ch.jalu.configme.resource.PropertyReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.Yaml;

final class MessageMigraterPropertyReader
implements PropertyReader {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private Map<String, Object> root;

    private MessageMigraterPropertyReader(Map<String, Object> valuesMap) {
        this.root = valuesMap;
    }

    public static MessageMigraterPropertyReader loadFromFile(File file) {
        MessageMigraterPropertyReader messageMigraterPropertyReader;
        FileInputStream is = new FileInputStream(file);
        try {
            messageMigraterPropertyReader = MessageMigraterPropertyReader.loadFromStream(is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Error while reading file '" + String.valueOf(file) + "'", e);
            }
        }
        ((InputStream)is).close();
        return messageMigraterPropertyReader;
    }

    public static MessageMigraterPropertyReader loadFromStream(InputStream inputStream) {
        Map<String, Object> valuesMap = MessageMigraterPropertyReader.readStreamToMap(inputStream);
        return new MessageMigraterPropertyReader(valuesMap);
    }

    public boolean contains(String path) {
        return this.getObject(path) != null;
    }

    public Set<String> getKeys(boolean b) {
        throw new UnsupportedOperationException();
    }

    public Set<String> getChildKeys(String s) {
        throw new UnsupportedOperationException();
    }

    public Object getObject(String path) {
        String[] keys;
        if (path.isEmpty()) {
            return this.root.get("");
        }
        Object node = this.root;
        for (String key : keys = path.split("\\.")) {
            if ((node = MessageMigraterPropertyReader.getIfIsMap(key, node)) != null) continue;
            return null;
        }
        return node;
    }

    public String getString(String path) {
        Object o = this.getObject(path);
        return o instanceof String ? (String)o : null;
    }

    public Integer getInt(String path) {
        throw new UnsupportedOperationException();
    }

    public Double getDouble(String path) {
        throw new UnsupportedOperationException();
    }

    public Boolean getBoolean(String path) {
        throw new UnsupportedOperationException();
    }

    public List<?> getList(String path) {
        throw new UnsupportedOperationException();
    }

    private static Map<String, Object> readStreamToMap(InputStream inputStream) {
        HashMap<String, Object> hashMap;
        InputStreamReader isr = new InputStreamReader(inputStream, CHARSET);
        try {
            Object obj = new Yaml().load((Reader)isr);
            hashMap = obj == null ? new HashMap() : (Map)obj;
        }
        catch (Throwable throwable) {
            try {
                try {
                    isr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ConfigMeException("Could not read stream", (Throwable)e);
            }
            catch (ClassCastException e) {
                throw new ConfigMeException("Top-level is not a map", (Throwable)e);
            }
        }
        isr.close();
        return hashMap;
    }

    private static Object getIfIsMap(String key, Object value) {
        if (value instanceof Map) {
            return ((Map)value).get(key);
        }
        return null;
    }
}

