/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.message.updater;

import ch.jalu.configme.properties.Property;
import ch.jalu.configme.resource.PropertyReader;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.message.updater.MessageMigraterPropertyReader;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.util.FileUtils;
import java.io.IOException;
import java.io.InputStream;

public class JarMessageSource {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(JarMessageSource.class);
    private final PropertyReader localJarMessages;
    private final PropertyReader defaultJarMessages;

    public JarMessageSource(String localJarPath, String defaultJarPath) {
        this.localJarMessages = localJarPath.equals(defaultJarPath) ? null : this.loadJarFile(localJarPath);
        this.defaultJarMessages = this.loadJarFile(defaultJarPath);
        if (this.defaultJarMessages == null) {
            throw new IllegalStateException("Default JAR file '" + defaultJarPath + "' could not be loaded");
        }
    }

    public String getMessageFromJar(Property<?> property) {
        String key = property.getPath();
        String message = JarMessageSource.getString(key, this.localJarMessages);
        return message == null ? JarMessageSource.getString(key, this.defaultJarMessages) : message;
    }

    private static String getString(String path, PropertyReader reader) {
        return reader == null ? null : reader.getString(path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MessageMigraterPropertyReader loadJarFile(String jarPath) {
        try (InputStream stream = FileUtils.getResourceFromJar(jarPath);){
            if (stream == null) {
                this.logger.debug("Could not load '" + jarPath + "' from JAR");
                MessageMigraterPropertyReader messageMigraterPropertyReader2 = null;
                return messageMigraterPropertyReader2;
            }
            MessageMigraterPropertyReader messageMigraterPropertyReader = MessageMigraterPropertyReader.loadFromStream(stream);
            return messageMigraterPropertyReader;
        }
        catch (IOException e) {
            this.logger.logException("Exception while handling JAR path '" + jarPath + "'", e);
            return null;
        }
    }
}

