/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.message;

import com.google.common.collect.ImmutableMap;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.mail.EmailService;
import fr.xephi.authme.message.MessageKey;
import fr.xephi.authme.message.MessagesFileHandler;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.util.expiring.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Messages {
    private static final String NEWLINE_TAG = "%nl%";
    private static final String USERNAME_TAG = "%username%";
    private static final String DISPLAYNAME_TAG = "%displayname%";
    private static final Map<TimeUnit, MessageKey> TIME_UNIT_SINGULARS = ImmutableMap.builder().put((Object)TimeUnit.SECONDS, (Object)MessageKey.SECOND).put((Object)TimeUnit.MINUTES, (Object)MessageKey.MINUTE).put((Object)TimeUnit.HOURS, (Object)MessageKey.HOUR).put((Object)TimeUnit.DAYS, (Object)MessageKey.DAY).build();
    private static final Map<TimeUnit, MessageKey> TIME_UNIT_PLURALS = ImmutableMap.builder().put((Object)TimeUnit.SECONDS, (Object)MessageKey.SECONDS).put((Object)TimeUnit.MINUTES, (Object)MessageKey.MINUTES).put((Object)TimeUnit.HOURS, (Object)MessageKey.HOURS).put((Object)TimeUnit.DAYS, (Object)MessageKey.DAYS).build();
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(EmailService.class);
    private MessagesFileHandler messagesFileHandler;

    @Inject
    Messages(MessagesFileHandler messagesFileHandler) {
        this.messagesFileHandler = messagesFileHandler;
    }

    public void send(CommandSender sender, MessageKey key) {
        String[] lines;
        for (String line : lines = this.retrieve(key, sender)) {
            sender.sendMessage(line);
        }
    }

    public void send(CommandSender sender, MessageKey key, String ... replacements) {
        String message = this.retrieveSingle(sender, key, replacements);
        for (String line : message.split("\n")) {
            sender.sendMessage(line);
        }
    }

    public String[] retrieve(MessageKey key, CommandSender sender) {
        String message = this.retrieveMessage(key, sender);
        if (message.isEmpty()) {
            return new String[0];
        }
        return message.split("\n");
    }

    public String formatDuration(Duration duration) {
        long value = duration.getDuration();
        MessageKey timeUnitKey = value == 1L ? TIME_UNIT_SINGULARS.get((Object)duration.getTimeUnit()) : TIME_UNIT_PLURALS.get((Object)duration.getTimeUnit());
        return value + " " + this.retrieveMessage(timeUnitKey, "");
    }

    private String retrieveMessage(MessageKey key, CommandSender sender) {
        String message = this.messagesFileHandler.getMessage(key.getKey());
        String displayName = sender.getName();
        if (sender instanceof Player) {
            displayName = ((Player)sender).getDisplayName();
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message).replace(NEWLINE_TAG, "\n").replace(USERNAME_TAG, sender.getName()).replace(DISPLAYNAME_TAG, displayName);
    }

    private String retrieveMessage(MessageKey key, String name) {
        String message = this.messagesFileHandler.getMessage(key.getKey());
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message).replace(NEWLINE_TAG, "\n").replace(USERNAME_TAG, name).replace(DISPLAYNAME_TAG, name);
    }

    public String retrieveSingle(CommandSender sender, MessageKey key, String ... replacements) {
        String message = this.retrieveMessage(key, sender);
        String[] tags = key.getTags();
        if (replacements.length == tags.length) {
            for (int i = 0; i < tags.length; ++i) {
                message = message.replace(tags[i], replacements[i]);
            }
        } else {
            this.logger.warning("Invalid number of replacements for message key '" + String.valueOf((Object)key) + "'");
        }
        return message;
    }

    public String retrieveSingle(String name, MessageKey key, String ... replacements) {
        String message = this.retrieveMessage(key, name);
        String[] tags = key.getTags();
        if (replacements.length == tags.length) {
            for (int i = 0; i < tags.length; ++i) {
                message = message.replace(tags[i], replacements[i]);
            }
        } else {
            this.logger.warning("Invalid number of replacements for message key '" + String.valueOf((Object)key) + "'");
        }
        return message;
    }
}

