/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.message;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.message.AbstractMessageFileHandler;
import fr.xephi.authme.message.MessagePathHelper;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.util.FileUtils;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.inject.Inject;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class HelpMessagesFileHandler
extends AbstractMessageFileHandler {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(HelpMessagesFileHandler.class);
    private FileConfiguration defaultConfiguration;

    @Inject
    HelpMessagesFileHandler() {
    }

    @Override
    public String getMessage(String key) {
        String message = this.getMessageIfExists(key);
        if (message == null) {
            this.logger.warning("Error getting message with key '" + key + "'. Please update your config file '" + this.getFilename() + "' or run /authme messages help");
            return this.getDefault(key);
        }
        return message;
    }

    private String getDefault(String key) {
        String message;
        if (this.defaultConfiguration == null) {
            InputStream stream = FileUtils.getResourceFromJar(this.createFilePath("en"));
            this.defaultConfiguration = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(stream));
        }
        return (message = this.defaultConfiguration.getString(key)) == null ? "Error retrieving message '" + key + "'" : message;
    }

    @Override
    protected String createFilePath(String language) {
        return MessagePathHelper.createHelpMessageFilePath(language);
    }
}

