/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.message;

import com.google.common.annotations.VisibleForTesting;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.initialization.DataFolder;
import fr.xephi.authme.initialization.Reloadable;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.PluginSettings;
import fr.xephi.authme.util.FileUtils;
import java.io.File;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class AbstractMessageFileHandler
implements Reloadable {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(AbstractMessageFileHandler.class);
    @DataFolder
    @Inject
    private File dataFolder;
    @Inject
    private Settings settings;
    private String filename;
    private FileConfiguration configuration;
    private final String defaultFile = this.createFilePath("en");

    protected AbstractMessageFileHandler() {
    }

    @Override
    @PostConstruct
    public void reload() {
        String language = (String)this.settings.getProperty(PluginSettings.MESSAGES_LANGUAGE);
        this.filename = this.createFilePath(language);
        File messagesFile = this.initializeFile(this.filename);
        this.configuration = YamlConfiguration.loadConfiguration((File)messagesFile);
    }

    protected String getLanguage() {
        return (String)this.settings.getProperty(PluginSettings.MESSAGES_LANGUAGE);
    }

    protected File getUserLanguageFile() {
        return new File(this.dataFolder, this.filename);
    }

    protected String getFilename() {
        return this.filename;
    }

    public boolean hasSection(String path) {
        return this.configuration.get(path) != null;
    }

    public String getMessage(String key) {
        String message = this.configuration.getString(key);
        return message == null ? "Error retrieving message '" + key + "'" : message;
    }

    public String getMessageIfExists(String key) {
        return this.configuration.getString(key);
    }

    protected abstract String createFilePath(String var1);

    @VisibleForTesting
    File initializeFile(String filePath) {
        File file = new File(this.dataFolder, filePath);
        if (FileUtils.getResourceFromJar(filePath) != null && FileUtils.copyFileFromResource(file, filePath)) {
            return file;
        }
        if (FileUtils.copyFileFromResource(file, this.defaultFile)) {
            return file;
        }
        this.logger.warning("Wanted to copy default messages file '" + this.defaultFile + "' from JAR but it didn't exist");
        return null;
    }
}

