/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.mail;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.initialization.DataFolder;
import fr.xephi.authme.mail.ImageGenerator;
import fr.xephi.authme.mail.SendMailSsl;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.EmailSettings;
import fr.xephi.authme.settings.properties.PluginSettings;
import fr.xephi.authme.settings.properties.SecuritySettings;
import fr.xephi.authme.util.FileUtils;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;

public class EmailService {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(EmailService.class);
    private final File dataFolder;
    private final Settings settings;
    private final SendMailSsl sendMailSsl;

    @Inject
    EmailService(@DataFolder File dataFolder, Settings settings, SendMailSsl sendMailSsl) {
        this.dataFolder = dataFolder;
        this.settings = settings;
        this.sendMailSsl = sendMailSsl;
    }

    public boolean hasAllInformation() {
        return this.sendMailSsl.hasAllInformation();
    }

    public boolean sendPasswordMail(String name, String mailAddress, String newPass) {
        HtmlEmail email;
        if (!this.hasAllInformation()) {
            this.logger.warning("Cannot perform email registration: not all email settings are complete");
            return false;
        }
        try {
            email = this.sendMailSsl.initializeMail(mailAddress);
        }
        catch (EmailException e) {
            this.logger.logException("Failed to create email with the given settings:", e);
            return false;
        }
        String mailText = this.replaceTagsForPasswordMail(this.settings.getPasswordEmailMessage(), name, newPass);
        File file = null;
        if (((Boolean)this.settings.getProperty(EmailSettings.PASSWORD_AS_IMAGE)).booleanValue()) {
            try {
                file = this.generatePasswordImage(name, newPass);
                mailText = EmailService.embedImageIntoEmailContent(file, email, mailText);
            }
            catch (IOException | EmailException e) {
                this.logger.logException("Unable to send new password as image for email " + mailAddress + ":", e);
            }
        }
        boolean couldSendEmail = this.sendMailSsl.sendEmail(mailText, email);
        FileUtils.delete(file);
        return couldSendEmail;
    }

    public boolean sendVerificationMail(String name, String mailAddress, String code) {
        HtmlEmail email;
        if (!this.hasAllInformation()) {
            this.logger.warning("Cannot send verification email: not all email settings are complete");
            return false;
        }
        try {
            email = this.sendMailSsl.initializeMail(mailAddress);
        }
        catch (EmailException e) {
            this.logger.logException("Failed to create verification email with the given settings:", e);
            return false;
        }
        String mailText = this.replaceTagsForVerificationEmail(this.settings.getVerificationEmailMessage(), name, code, (Integer)this.settings.getProperty(SecuritySettings.VERIFICATION_CODE_EXPIRATION_MINUTES));
        return this.sendMailSsl.sendEmail(mailText, email);
    }

    public boolean sendRecoveryCode(String name, String email, String code) {
        HtmlEmail htmlEmail;
        try {
            htmlEmail = this.sendMailSsl.initializeMail(email);
        }
        catch (EmailException e) {
            this.logger.logException("Failed to create email for recovery code:", e);
            return false;
        }
        String message = this.replaceTagsForRecoveryCodeMail(this.settings.getRecoveryCodeEmailMessage(), name, code, (Integer)this.settings.getProperty(SecuritySettings.RECOVERY_CODE_HOURS_VALID));
        return this.sendMailSsl.sendEmail(message, htmlEmail);
    }

    private File generatePasswordImage(String name, String newPass) throws IOException {
        ImageGenerator gen = new ImageGenerator(newPass);
        File file = new File(this.dataFolder, name + "_new_pass.jpg");
        ImageIO.write((RenderedImage)gen.generateImage(), "jpg", file);
        return file;
    }

    private static String embedImageIntoEmailContent(File image, HtmlEmail email, String content) throws EmailException {
        FileDataSource source = new FileDataSource(image);
        String tag = email.embed((DataSource)source, image.getName());
        return content.replace("<image />", "<img src=\"cid:" + tag + "\">");
    }

    private String replaceTagsForPasswordMail(String mailText, String name, String newPass) {
        return mailText.replace("<playername />", name).replace("<servername />", (CharSequence)this.settings.getProperty(PluginSettings.SERVER_NAME)).replace("<generatedpass />", newPass);
    }

    private String replaceTagsForVerificationEmail(String mailText, String name, String code, int minutesValid) {
        return mailText.replace("<playername />", name).replace("<servername />", (CharSequence)this.settings.getProperty(PluginSettings.SERVER_NAME)).replace("<generatedcode />", code).replace("<minutesvalid />", String.valueOf(minutesValid));
    }

    private String replaceTagsForRecoveryCodeMail(String mailText, String name, String code, int hoursValid) {
        return mailText.replace("<playername />", name).replace("<servername />", (CharSequence)this.settings.getProperty(PluginSettings.SERVER_NAME)).replace("<recoverycode />", code).replace("<hoursvalid />", String.valueOf(hoursValid));
    }
}

