/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.listener.protocollib;

import ch.jalu.injector.annotations.NoFieldScan;
import fr.xephi.authme.AuthMe;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.data.auth.PlayerCache;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.initialization.SettingsDependent;
import fr.xephi.authme.listener.protocollib.InventoryPacketAdapter;
import fr.xephi.authme.listener.protocollib.TabCompletePacketAdapter;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.service.BukkitService;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import javax.inject.Inject;
import org.bukkit.entity.Player;

@NoFieldScan
public class ProtocolLibService
implements SettingsDependent {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(ProtocolLibService.class);
    private InventoryPacketAdapter inventoryPacketAdapter;
    private TabCompletePacketAdapter tabCompletePacketAdapter;
    private boolean protectInvBeforeLogin;
    private boolean denyTabCompleteBeforeLogin;
    private boolean isEnabled;
    private final AuthMe plugin;
    private final BukkitService bukkitService;
    private final PlayerCache playerCache;
    private final DataSource dataSource;

    @Inject
    ProtocolLibService(AuthMe plugin, Settings settings, BukkitService bukkitService, PlayerCache playerCache, DataSource dataSource) {
        this.plugin = plugin;
        this.bukkitService = bukkitService;
        this.playerCache = playerCache;
        this.dataSource = dataSource;
        this.reload(settings);
    }

    public void setup() {
        if (!this.plugin.getServer().getPluginManager().isPluginEnabled("ProtocolLib")) {
            if (this.protectInvBeforeLogin) {
                this.logger.warning("WARNING! The protectInventory feature requires ProtocolLib! Disabling it...");
            }
            if (this.denyTabCompleteBeforeLogin) {
                this.logger.warning("WARNING! The denyTabComplete feature requires ProtocolLib! Disabling it...");
            }
            this.isEnabled = false;
            return;
        }
        if (this.protectInvBeforeLogin) {
            if (this.inventoryPacketAdapter == null) {
                this.inventoryPacketAdapter = new InventoryPacketAdapter(this.plugin, this.playerCache, this.dataSource);
                this.inventoryPacketAdapter.register(this.bukkitService);
            }
        } else if (this.inventoryPacketAdapter != null) {
            this.inventoryPacketAdapter.unregister();
            this.inventoryPacketAdapter = null;
        }
        if (this.denyTabCompleteBeforeLogin) {
            if (this.tabCompletePacketAdapter == null) {
                this.tabCompletePacketAdapter = new TabCompletePacketAdapter(this.plugin, this.playerCache);
                this.tabCompletePacketAdapter.register();
            }
        } else if (this.tabCompletePacketAdapter != null) {
            this.tabCompletePacketAdapter.unregister();
            this.tabCompletePacketAdapter = null;
        }
        this.isEnabled = true;
    }

    public void disable() {
        this.isEnabled = false;
        if (this.inventoryPacketAdapter != null) {
            this.inventoryPacketAdapter.unregister();
            this.inventoryPacketAdapter = null;
        }
        if (this.tabCompletePacketAdapter != null) {
            this.tabCompletePacketAdapter.unregister();
            this.tabCompletePacketAdapter = null;
        }
    }

    public void sendBlankInventoryPacket(Player player) {
        if (this.isEnabled && this.inventoryPacketAdapter != null) {
            this.inventoryPacketAdapter.sendBlankInventoryPacket(player);
        }
    }

    @Override
    public void reload(Settings settings) {
        boolean oldProtectInventory = this.protectInvBeforeLogin;
        this.protectInvBeforeLogin = (Boolean)settings.getProperty(RestrictionSettings.PROTECT_INVENTORY_BEFORE_LOGIN);
        this.denyTabCompleteBeforeLogin = (Boolean)settings.getProperty(RestrictionSettings.DENY_TABCOMPLETE_BEFORE_LOGIN);
        if (oldProtectInventory && !this.protectInvBeforeLogin && this.inventoryPacketAdapter != null) {
            this.inventoryPacketAdapter.unregister();
            for (Player onlinePlayer : this.bukkitService.getOnlinePlayers()) {
                if (this.playerCache.isAuthenticated(onlinePlayer.getName())) continue;
                onlinePlayer.updateInventory();
            }
        }
        this.setup();
    }
}

