/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.listener;

import fr.xephi.authme.data.QuickCommandsProtectionManager;
import fr.xephi.authme.data.auth.PlayerAuth;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.listener.FailedVerificationException;
import fr.xephi.authme.listener.ListenerService;
import fr.xephi.authme.listener.OnJoinVerifier;
import fr.xephi.authme.listener.PlayerListener19Spigot;
import fr.xephi.authme.message.MessageKey;
import fr.xephi.authme.message.Messages;
import fr.xephi.authme.permission.PermissionsManager;
import fr.xephi.authme.permission.PlayerStatePermission;
import fr.xephi.authme.process.Management;
import fr.xephi.authme.service.AntiBotService;
import fr.xephi.authme.service.BukkitService;
import fr.xephi.authme.service.JoinMessageService;
import fr.xephi.authme.service.TeleportationService;
import fr.xephi.authme.service.ValidationService;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.SpawnLoader;
import fr.xephi.authme.settings.properties.HooksSettings;
import fr.xephi.authme.settings.properties.RegistrationSettings;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.inventory.InventoryView;

public class PlayerListener
implements Listener {
    @Inject
    private Settings settings;
    @Inject
    private Messages messages;
    @Inject
    private DataSource dataSource;
    @Inject
    private AntiBotService antiBotService;
    @Inject
    private Management management;
    @Inject
    private BukkitService bukkitService;
    @Inject
    private SpawnLoader spawnLoader;
    @Inject
    private OnJoinVerifier onJoinVerifier;
    @Inject
    private ListenerService listenerService;
    @Inject
    private TeleportationService teleportationService;
    @Inject
    private ValidationService validationService;
    @Inject
    private JoinMessageService joinMessageService;
    @Inject
    private PermissionsManager permissionsManager;
    @Inject
    private QuickCommandsProtectionManager quickCommandsProtectionManager;

    @EventHandler(priority=EventPriority.LOWEST)
    public void onAsyncPlayerPreLoginEventLowest(AsyncPlayerPreLoginEvent event) {
        if (event.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            return;
        }
        String name = event.getName();
        if (event.getAddress() == null) {
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, this.messages.retrieveSingle(name, MessageKey.KICK_UNRESOLVED_HOSTNAME, new String[0]));
            return;
        }
        if (this.validationService.isUnrestricted(name)) {
            return;
        }
        try {
            this.onJoinVerifier.checkIsValidName(name);
        }
        catch (FailedVerificationException e) {
            event.setKickMessage(this.messages.retrieveSingle(name, e.getReason(), e.getArgs()));
            event.setLoginResult(AsyncPlayerPreLoginEvent.Result.KICK_OTHER);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onAsyncPlayerPreLoginEventHighest(AsyncPlayerPreLoginEvent event) {
        if (event.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            return;
        }
        String name = event.getName();
        if (this.validationService.isUnrestricted(name)) {
            return;
        }
        try {
            PlayerAuth auth = this.dataSource.getAuth(name);
            boolean isAuthAvailable = auth != null;
            this.onJoinVerifier.checkKickNonRegistered(isAuthAvailable);
            this.onJoinVerifier.checkAntibot(name, isAuthAvailable);
            this.onJoinVerifier.checkNameCasing(name, auth);
            String ip = event.getAddress().getHostAddress();
            this.onJoinVerifier.checkPlayerCountry(name, ip, isAuthAvailable);
        }
        catch (FailedVerificationException e) {
            event.setKickMessage(this.messages.retrieveSingle(name, e.getReason(), e.getArgs()));
            event.setLoginResult(AsyncPlayerPreLoginEvent.Result.KICK_OTHER);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerLogin(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        String name = player.getName();
        try {
            this.onJoinVerifier.checkSingleSession(name);
        }
        catch (FailedVerificationException e) {
            event.setKickMessage(this.messages.retrieveSingle(name, e.getReason(), e.getArgs()));
            event.setResult(PlayerLoginEvent.Result.KICK_OTHER);
            return;
        }
        if (this.validationService.isUnrestricted(name)) {
            return;
        }
        this.onJoinVerifier.refusePlayerForFullServer(event);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!PlayerListener19Spigot.isPlayerSpawnLocationEventCalled()) {
            this.teleportationService.teleportOnJoin(player);
        }
        this.quickCommandsProtectionManager.processJoin(player);
        this.management.performJoin(player);
        this.teleportationService.teleportNewPlayerToFirstSpawn(player);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onJoinMessage(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (((Boolean)this.settings.getProperty(RegistrationSettings.REMOVE_JOIN_MESSAGE)).booleanValue()) {
            event.setJoinMessage(null);
            return;
        }
        String customJoinMessage = (String)this.settings.getProperty(RegistrationSettings.CUSTOM_JOIN_MESSAGE);
        if (!customJoinMessage.isEmpty()) {
            customJoinMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)customJoinMessage);
            event.setJoinMessage(customJoinMessage.replace("{PLAYERNAME}", player.getName()).replace("{DISPLAYNAME}", player.getDisplayName()).replace("{DISPLAYNAMENOCOLOR}", ChatColor.stripColor((String)player.getDisplayName())));
        }
        if (!((Boolean)this.settings.getProperty(RegistrationSettings.DELAY_JOIN_MESSAGE)).booleanValue()) {
            return;
        }
        String name = player.getName().toLowerCase(Locale.ROOT);
        String joinMsg = event.getJoinMessage();
        if (joinMsg != null) {
            event.setJoinMessage(null);
            this.joinMessageService.putMessage(name, joinMsg);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (((Boolean)this.settings.getProperty(RegistrationSettings.REMOVE_LEAVE_MESSAGE)).booleanValue()) {
            event.setQuitMessage(null);
        } else if (((Boolean)this.settings.getProperty(RegistrationSettings.REMOVE_UNLOGGED_LEAVE_MESSAGE)).booleanValue() && this.listenerService.shouldCancelEvent((PlayerEvent)event)) {
            event.setQuitMessage(null);
        }
        if (this.antiBotService.wasPlayerKicked(player.getName())) {
            return;
        }
        this.management.performQuit(player);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPlayerKick(PlayerKickEvent event) {
        if (((Boolean)this.settings.getProperty(RestrictionSettings.FORCE_SINGLE_SESSION)).booleanValue() && event.getReason().contains("You logged in from another location")) {
            event.setCancelled(true);
            return;
        }
        Player player = event.getPlayer();
        if (!this.antiBotService.wasPlayerKicked(player.getName())) {
            this.management.performQuit(player);
        }
    }

    private void removeUnauthorizedRecipients(AsyncPlayerChatEvent event) {
        if (((Boolean)this.settings.getProperty(RestrictionSettings.HIDE_CHAT)).booleanValue()) {
            event.getRecipients().removeIf(this.listenerService::shouldCancelEvent);
            if (event.getRecipients().isEmpty()) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        boolean mayPlayerSendChat;
        if (((Boolean)this.settings.getProperty(RestrictionSettings.ALLOW_CHAT)).booleanValue()) {
            return;
        }
        Player player = event.getPlayer();
        boolean bl = mayPlayerSendChat = !this.listenerService.shouldCancelEvent(player) || this.permissionsManager.hasPermission((CommandSender)player, PlayerStatePermission.ALLOW_CHAT_BEFORE_LOGIN);
        if (mayPlayerSendChat) {
            this.removeUnauthorizedRecipients(event);
        } else {
            event.setCancelled(true);
            this.messages.send((CommandSender)player, MessageKey.DENIED_CHAT);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        String cmd = event.getMessage().split(" ")[0].toLowerCase(Locale.ROOT);
        if (((Boolean)this.settings.getProperty(HooksSettings.USE_ESSENTIALS_MOTD)).booleanValue() && "/motd".equals(cmd)) {
            return;
        }
        if (((Set)this.settings.getProperty(RestrictionSettings.ALLOW_COMMANDS)).contains(cmd)) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.quickCommandsProtectionManager.isAllowed(player.getName())) {
            event.setCancelled(true);
            player.kickPlayer(this.messages.retrieveSingle((CommandSender)player, MessageKey.QUICK_COMMAND_PROTECTION_KICK, new String[0]));
            return;
        }
        if (this.listenerService.shouldCancelEvent(player)) {
            event.setCancelled(true);
            this.messages.send((CommandSender)player, MessageKey.DENIED_COMMAND);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (((Boolean)this.settings.getProperty(RestrictionSettings.ALLOW_UNAUTHED_MOVEMENT)).booleanValue() && (Integer)this.settings.getProperty(RestrictionSettings.ALLOWED_MOVEMENT_RADIUS) <= 0) {
            return;
        }
        Location from = event.getFrom();
        Location to = event.getTo();
        if (to == null) {
            return;
        }
        if (from.getBlockX() == to.getBlockX() && from.getBlockZ() == to.getBlockZ() && from.getY() - to.getY() >= 0.0) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.listenerService.shouldCancelEvent(player)) {
            return;
        }
        if (!((Boolean)this.settings.getProperty(RestrictionSettings.ALLOW_UNAUTHED_MOVEMENT)).booleanValue()) {
            event.setTo(event.getFrom());
            return;
        }
        if (((Boolean)this.settings.getProperty(RestrictionSettings.NO_TELEPORT)).booleanValue()) {
            return;
        }
        Location spawn = this.spawnLoader.getSpawnLocation(player);
        if (spawn != null && spawn.getWorld() != null) {
            if (!player.getWorld().equals(spawn.getWorld())) {
                player.teleport(spawn);
            } else if (spawn.distance(player.getLocation()) > (double)((Integer)this.settings.getProperty(RestrictionSettings.ALLOWED_MOVEMENT_RADIUS)).intValue()) {
                player.teleport(spawn);
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (((Boolean)this.settings.getProperty(RestrictionSettings.NO_TELEPORT)).booleanValue()) {
            return;
        }
        if (!this.listenerService.shouldCancelEvent((PlayerEvent)event)) {
            return;
        }
        Location spawn = this.spawnLoader.getSpawnLocation(event.getPlayer());
        if (spawn != null && spawn.getWorld() != null) {
            event.setRespawnLocation(spawn);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (this.listenerService.shouldCancelEvent((PlayerEvent)event)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (this.listenerService.shouldCancelEvent((PlayerEvent)event)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent event) {
        if (this.listenerService.shouldCancelEvent((PlayerEvent)event)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerHitPlayerEvent(EntityDamageByEntityEvent event) {
        if (this.listenerService.shouldCancelEvent((EntityEvent)event)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerShear(PlayerShearEntityEvent event) {
        if (this.listenerService.shouldCancelEvent((PlayerEvent)event)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerFish(PlayerFishEvent event) {
        if (this.listenerService.shouldCancelEvent((PlayerEvent)event)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerBedEnter(PlayerBedEnterEvent event) {
        if (this.listenerService.shouldCancelEvent((PlayerEvent)event)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerEditBook(PlayerEditBookEvent event) {
        if (this.listenerService.shouldCancelEvent((PlayerEvent)event)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onSignChange(SignChangeEvent event) {
        Player player = event.getPlayer();
        if (this.listenerService.shouldCancelEvent(player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        if (this.listenerService.shouldCancelEvent((PlayerEvent)event)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        if (this.listenerService.shouldCancelEvent((PlayerEvent)event)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerHeldItem(PlayerItemHeldEvent event) {
        if (this.listenerService.shouldCancelEvent((PlayerEvent)event)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerConsumeItem(PlayerItemConsumeEvent event) {
        if (this.listenerService.shouldCancelEvent((PlayerEvent)event)) {
            event.setCancelled(true);
        }
    }

    private boolean isInventoryWhitelisted(InventoryView inventory) {
        if (inventory == null) {
            return false;
        }
        Set whitelist = (Set)this.settings.getProperty(RestrictionSettings.UNRESTRICTED_INVENTORIES);
        return whitelist.contains(ChatColor.stripColor((String)inventory.getTitle()).toLowerCase(Locale.ROOT));
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerInventoryOpen(InventoryOpenEvent event) {
        HumanEntity player = event.getPlayer();
        if (this.listenerService.shouldCancelEvent((Entity)player) && !this.isInventoryWhitelisted(event.getView())) {
            event.setCancelled(true);
            this.bukkitService.scheduleSyncDelayedTask(() -> ((HumanEntity)player).closeInventory(), 1L);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerInventoryClick(InventoryClickEvent event) {
        if (this.listenerService.shouldCancelEvent((Entity)event.getWhoClicked()) && !this.isInventoryWhitelisted(event.getView())) {
            event.setCancelled(true);
        }
    }
}

