/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.listener;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.data.auth.PlayerAuth;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.initialization.Reloadable;
import fr.xephi.authme.listener.FailedVerificationException;
import fr.xephi.authme.message.MessageKey;
import fr.xephi.authme.message.Messages;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.permission.PermissionNode;
import fr.xephi.authme.permission.PermissionsManager;
import fr.xephi.authme.permission.PlayerStatePermission;
import fr.xephi.authme.service.AntiBotService;
import fr.xephi.authme.service.BukkitService;
import fr.xephi.authme.service.ValidationService;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.ProtectionSettings;
import fr.xephi.authme.settings.properties.RegistrationSettings;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import fr.xephi.authme.util.StringUtils;
import fr.xephi.authme.util.Utils;
import java.util.Collection;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerLoginEvent;

public class OnJoinVerifier
implements Reloadable {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(OnJoinVerifier.class);
    @Inject
    private Settings settings;
    @Inject
    private DataSource dataSource;
    @Inject
    private Messages messages;
    @Inject
    private PermissionsManager permissionsManager;
    @Inject
    private AntiBotService antiBotService;
    @Inject
    private ValidationService validationService;
    @Inject
    private BukkitService bukkitService;
    @Inject
    private Server server;
    private Pattern nicknamePattern;

    OnJoinVerifier() {
    }

    @Override
    @PostConstruct
    public void reload() {
        String nickRegEx = (String)this.settings.getProperty(RestrictionSettings.ALLOWED_NICKNAME_CHARACTERS);
        this.nicknamePattern = Utils.safePatternCompile(nickRegEx);
    }

    public void checkAntibot(String name, boolean isAuthAvailable) throws FailedVerificationException {
        if (isAuthAvailable || this.permissionsManager.hasPermissionOffline(name, (PermissionNode)PlayerStatePermission.BYPASS_ANTIBOT)) {
            return;
        }
        if (this.antiBotService.shouldKick()) {
            this.antiBotService.addPlayerKick(name);
            throw new FailedVerificationException(MessageKey.KICK_ANTIBOT, new String[0]);
        }
    }

    public void checkKickNonRegistered(boolean isAuthAvailable) throws FailedVerificationException {
        if (!isAuthAvailable && ((Boolean)this.settings.getProperty(RestrictionSettings.KICK_NON_REGISTERED)).booleanValue()) {
            throw new FailedVerificationException(MessageKey.MUST_REGISTER_MESSAGE, new String[0]);
        }
    }

    public void checkIsValidName(String name) throws FailedVerificationException {
        if (name.length() > (Integer)this.settings.getProperty(RestrictionSettings.MAX_NICKNAME_LENGTH) || name.length() < (Integer)this.settings.getProperty(RestrictionSettings.MIN_NICKNAME_LENGTH)) {
            throw new FailedVerificationException(MessageKey.INVALID_NAME_LENGTH, new String[0]);
        }
        if (!this.nicknamePattern.matcher(name).matches()) {
            throw new FailedVerificationException(MessageKey.INVALID_NAME_CHARACTERS, this.nicknamePattern.pattern());
        }
    }

    public boolean refusePlayerForFullServer(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        if (event.getResult() != PlayerLoginEvent.Result.KICK_FULL) {
            return false;
        }
        if (!this.permissionsManager.hasPermission((CommandSender)player, PlayerStatePermission.IS_VIP)) {
            event.setKickMessage(this.messages.retrieveSingle((CommandSender)player, MessageKey.KICK_FULL_SERVER, new String[0]));
            return true;
        }
        Collection<Player> onlinePlayers = this.bukkitService.getOnlinePlayers();
        if (onlinePlayers.size() < this.server.getMaxPlayers()) {
            event.allow();
            return false;
        }
        Player nonVipPlayer = this.generateKickPlayer(onlinePlayers);
        if (nonVipPlayer != null) {
            nonVipPlayer.kickPlayer(this.messages.retrieveSingle((CommandSender)player, MessageKey.KICK_FOR_VIP, new String[0]));
            event.allow();
            return false;
        }
        this.logger.info("VIP player " + player.getName() + " tried to join, but the server was full");
        event.setKickMessage(this.messages.retrieveSingle((CommandSender)player, MessageKey.KICK_FULL_SERVER, new String[0]));
        return true;
    }

    public void checkNameCasing(String connectingName, PlayerAuth auth) throws FailedVerificationException {
        if (auth != null && ((Boolean)this.settings.getProperty(RegistrationSettings.PREVENT_OTHER_CASE)).booleanValue()) {
            String realName = auth.getRealName();
            if (StringUtils.isBlank(realName) || "Player".equals(realName)) {
                this.dataSource.updateRealName(connectingName.toLowerCase(Locale.ROOT), connectingName);
            } else if (!realName.equals(connectingName)) {
                throw new FailedVerificationException(MessageKey.INVALID_NAME_CASE, realName, connectingName);
            }
        }
    }

    public void checkPlayerCountry(String name, String address, boolean isAuthAvailable) throws FailedVerificationException {
        if (!(isAuthAvailable && !((Boolean)this.settings.getProperty(ProtectionSettings.ENABLE_PROTECTION_REGISTERED)).booleanValue() || !((Boolean)this.settings.getProperty(ProtectionSettings.ENABLE_PROTECTION)).booleanValue() || this.permissionsManager.hasPermissionOffline(name, (PermissionNode)PlayerStatePermission.BYPASS_COUNTRY_CHECK) || this.validationService.isCountryAdmitted(address))) {
            throw new FailedVerificationException(MessageKey.COUNTRY_BANNED_ERROR, new String[0]);
        }
    }

    public void checkSingleSession(String name) throws FailedVerificationException {
        if (!((Boolean)this.settings.getProperty(RestrictionSettings.FORCE_SINGLE_SESSION)).booleanValue()) {
            return;
        }
        Player onlinePlayer = this.bukkitService.getPlayerExact(name);
        if (onlinePlayer != null) {
            throw new FailedVerificationException(MessageKey.USERNAME_ALREADY_ONLINE_ERROR, new String[0]);
        }
    }

    private Player generateKickPlayer(Collection<Player> onlinePlayers) {
        for (Player player : onlinePlayers) {
            if (this.permissionsManager.hasPermission((CommandSender)player, PlayerStatePermission.IS_VIP)) continue;
            return player;
        }
        return null;
    }
}

