/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.initialization;

import ch.jalu.configme.configurationdata.ConfigurationData;
import ch.jalu.configme.migration.MigrationService;
import ch.jalu.configme.resource.PropertyResource;
import ch.jalu.configme.resource.YamlFileResource;
import fr.xephi.authme.initialization.DataFolder;
import fr.xephi.authme.service.yaml.YamlFileResourceProvider;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.SettingsMigrationService;
import fr.xephi.authme.settings.properties.AuthMeSettingsRetriever;
import fr.xephi.authme.util.FileUtils;
import java.io.File;
import javax.inject.Inject;
import javax.inject.Provider;

public class SettingsProvider
implements Provider<Settings> {
    @Inject
    @DataFolder
    private File dataFolder;
    @Inject
    private SettingsMigrationService migrationService;

    SettingsProvider() {
    }

    public Settings get() {
        File configFile = new File(this.dataFolder, "config.yml");
        if (!configFile.exists()) {
            FileUtils.create(configFile);
        }
        YamlFileResource resource = YamlFileResourceProvider.loadFromFile(configFile);
        ConfigurationData configurationData = AuthMeSettingsRetriever.buildConfigurationData();
        return new Settings(this.dataFolder, (PropertyResource)resource, (MigrationService)this.migrationService, configurationData);
    }
}

