/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.initialization;

import fr.xephi.authme.AuthMe;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.datasource.DataSourceType;
import fr.xephi.authme.message.MessageKey;
import fr.xephi.authme.message.Messages;
import fr.xephi.authme.output.ConsoleFilter;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.output.Log4JFilter;
import fr.xephi.authme.service.BukkitService;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.DatabaseSettings;
import fr.xephi.authme.settings.properties.EmailSettings;
import fr.xephi.authme.settings.properties.PluginSettings;
import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.bstats.bukkit.Metrics;
import org.bstats.charts.CustomChart;
import org.bstats.charts.SimplePie;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class OnStartupTasks {
    private static final ConsoleLogger consoleLogger = ConsoleLoggerFactory.get(OnStartupTasks.class);
    @Inject
    private DataSource dataSource;
    @Inject
    private Settings settings;
    @Inject
    private BukkitService bukkitService;
    @Inject
    private Messages messages;

    OnStartupTasks() {
    }

    public static void sendMetrics(AuthMe plugin, Settings settings) {
        System.setProperty("bstats.relocatecheck", "false");
        Metrics metrics = new Metrics((JavaPlugin)plugin, 164);
        metrics.addCustomChart((CustomChart)new SimplePie("messages_language", () -> (String)settings.getProperty(PluginSettings.MESSAGES_LANGUAGE)));
        metrics.addCustomChart((CustomChart)new SimplePie("database_backend", () -> ((DataSourceType)((Object)((Object)settings.getProperty(DatabaseSettings.BACKEND)))).toString()));
    }

    public static void setupConsoleFilter(Logger logger) {
        try {
            Class.forName("org.apache.logging.log4j.core.filter.AbstractFilter");
            OnStartupTasks.setLog4JFilter();
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            consoleLogger.info("You're using Minecraft 1.6.x or older, Log4J support will be disabled");
            ConsoleFilter filter = new ConsoleFilter();
            logger.setFilter(filter);
            Bukkit.getLogger().setFilter(filter);
            Logger.getLogger("Minecraft").setFilter(filter);
        }
    }

    private static void setLog4JFilter() {
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
        logger.addFilter((Filter)new Log4JFilter());
    }

    public void scheduleRecallEmailTask() {
        if (!((Boolean)this.settings.getProperty(EmailSettings.RECALL_PLAYERS)).booleanValue()) {
            return;
        }
        this.bukkitService.runTaskTimerAsynchronously(new BukkitRunnable(){

            public void run() {
                List<String> loggedPlayersWithEmptyMail = OnStartupTasks.this.dataSource.getLoggedPlayersWithEmptyMail();
                OnStartupTasks.this.bukkitService.runTask(() -> {
                    for (String playerWithoutMail : loggedPlayersWithEmptyMail) {
                        Player player = OnStartupTasks.this.bukkitService.getPlayerExact(playerWithoutMail);
                        if (player == null) continue;
                        OnStartupTasks.this.messages.send((CommandSender)player, MessageKey.ADD_EMAIL_MESSAGE);
                    }
                });
            }
        }, 1L, 1200L * (long)((Integer)this.settings.getProperty(EmailSettings.DELAY_RECALL)).intValue());
    }
}

