/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.initialization;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.data.auth.PlayerCache;
import fr.xephi.authme.datasource.CacheDataSource;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.datasource.DataSourceType;
import fr.xephi.authme.datasource.MariaDB;
import fr.xephi.authme.datasource.MySQL;
import fr.xephi.authme.datasource.PostgreSqlDataSource;
import fr.xephi.authme.datasource.SQLite;
import fr.xephi.authme.datasource.mysqlextensions.MySqlExtensionsFactory;
import fr.xephi.authme.initialization.DataFolder;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.service.BukkitService;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.DatabaseSettings;
import java.io.File;
import java.sql.SQLException;
import javax.inject.Inject;
import javax.inject.Provider;

public class DataSourceProvider
implements Provider<DataSource> {
    private static final int SQLITE_MAX_SIZE = 4000;
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(DataSourceProvider.class);
    @Inject
    @DataFolder
    private File dataFolder;
    @Inject
    private Settings settings;
    @Inject
    private BukkitService bukkitService;
    @Inject
    private PlayerCache playerCache;
    @Inject
    private MySqlExtensionsFactory mySqlExtensionsFactory;

    DataSourceProvider() {
    }

    public DataSource get() {
        try {
            return this.createDataSource();
        }
        catch (Exception e) {
            this.logger.logException("Could not create data source:", e);
            throw new IllegalStateException("Error during initialization of data source", e);
        }
    }

    private DataSource createDataSource() throws SQLException {
        DataSourceType dataSourceType = (DataSourceType)((Object)this.settings.getProperty(DatabaseSettings.BACKEND));
        DataSource dataSource = switch (dataSourceType) {
            case DataSourceType.MYSQL -> new MySQL(this.settings, this.mySqlExtensionsFactory);
            case DataSourceType.MARIADB -> new MariaDB(this.settings, this.mySqlExtensionsFactory);
            case DataSourceType.POSTGRESQL -> new PostgreSqlDataSource(this.settings, this.mySqlExtensionsFactory);
            case DataSourceType.SQLITE -> new SQLite(this.settings, this.dataFolder);
            default -> throw new UnsupportedOperationException("Unknown data source type '" + String.valueOf((Object)dataSourceType) + "'");
        };
        if (((Boolean)this.settings.getProperty(DatabaseSettings.USE_CACHING)).booleanValue()) {
            dataSource = new CacheDataSource(dataSource, this.playerCache);
        }
        if (DataSourceType.SQLITE.equals((Object)dataSourceType)) {
            this.checkDataSourceSize(dataSource);
        }
        return dataSource;
    }

    private void checkDataSourceSize(DataSource dataSource) {
        this.bukkitService.runTaskAsynchronously(() -> {
            int accounts = dataSource.getAccountsRegistered();
            if (accounts >= 4000) {
                this.logger.warning("YOU'RE USING THE SQLITE DATABASE WITH " + accounts + "+ ACCOUNTS; FOR BETTER PERFORMANCE, PLEASE UPGRADE TO MYSQL!!");
            }
        });
    }
}

