/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.datasource.mysqlextensions;

import fr.xephi.authme.datasource.Columns;
import fr.xephi.authme.datasource.mysqlextensions.Ipb4Extension;
import fr.xephi.authme.datasource.mysqlextensions.MySqlExtension;
import fr.xephi.authme.datasource.mysqlextensions.NoOpExtension;
import fr.xephi.authme.datasource.mysqlextensions.PhpBbExtension;
import fr.xephi.authme.datasource.mysqlextensions.WordpressExtension;
import fr.xephi.authme.datasource.mysqlextensions.XfBcryptExtension;
import fr.xephi.authme.security.HashAlgorithm;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.SecuritySettings;
import javax.inject.Inject;

public class MySqlExtensionsFactory {
    @Inject
    private Settings settings;

    public MySqlExtension buildExtension(Columns columnsConfig) {
        HashAlgorithm hash = (HashAlgorithm)((Object)this.settings.getProperty(SecuritySettings.PASSWORD_HASH));
        switch (hash) {
            case IPB4: {
                return new Ipb4Extension(this.settings, columnsConfig);
            }
            case PHPBB: {
                return new PhpBbExtension(this.settings, columnsConfig);
            }
            case WORDPRESS: {
                return new WordpressExtension(this.settings, columnsConfig);
            }
            case XFBCRYPT: {
                return new XfBcryptExtension(this.settings, columnsConfig);
            }
        }
        return new NoOpExtension(this.settings, columnsConfig);
    }
}

