/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.datasource.mysqlextensions;

import fr.xephi.authme.data.auth.PlayerAuth;
import fr.xephi.authme.datasource.Columns;
import fr.xephi.authme.security.crypts.HashedPassword;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.DatabaseSettings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.OptionalInt;

public abstract class MySqlExtension {
    protected final Columns col;
    protected final String tableName;

    MySqlExtension(Settings settings, Columns col) {
        this.col = col;
        this.tableName = (String)settings.getProperty(DatabaseSettings.MYSQL_TABLE);
    }

    public void saveAuth(PlayerAuth auth, Connection con) throws SQLException {
    }

    public void extendAuth(PlayerAuth auth, int id, Connection con) throws SQLException {
    }

    public void changePassword(String user, HashedPassword password, Connection con) throws SQLException {
    }

    public void removeAuth(String user, Connection con) throws SQLException {
    }

    protected OptionalInt retrieveIdFromTable(String name, Connection con) throws SQLException {
        String sql = "SELECT " + this.col.ID + " FROM " + this.tableName + " WHERE " + this.col.NAME + "=?;";
        try (PreparedStatement pst = con.prepareStatement(sql);){
            pst.setString(1, name);
            try (ResultSet rs = pst.executeQuery();){
                if (rs.next()) {
                    OptionalInt optionalInt = OptionalInt.of(rs.getInt(this.col.ID));
                    return optionalInt;
                }
            }
        }
        return OptionalInt.empty();
    }
}

