/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.datasource.converter;

import de.luricos.bukkit.xAuth.database.DatabaseTables;
import de.luricos.bukkit.xAuth.utils.xAuthLog;
import de.luricos.bukkit.xAuth.xAuth;
import fr.xephi.authme.data.auth.PlayerAuth;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.datasource.converter.Converter;
import fr.xephi.authme.initialization.DataFolder;
import fr.xephi.authme.util.FileUtils;
import fr.xephi.authme.util.Utils;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.PluginManager;

public class XAuthConverter
implements Converter {
    @Inject
    @DataFolder
    private File dataFolder;
    @Inject
    private DataSource database;
    @Inject
    private PluginManager pluginManager;

    XAuthConverter() {
    }

    @Override
    public void execute(CommandSender sender) {
        try {
            Class.forName("de.luricos.bukkit.xAuth.xAuth");
            this.convert(sender);
        }
        catch (ClassNotFoundException ce) {
            sender.sendMessage("xAuth has not been found, please put xAuth.jar in your plugin folder and restart!");
        }
    }

    private void convert(CommandSender sender) {
        List<Integer> players;
        if (this.pluginManager.getPlugin("xAuth") == null) {
            sender.sendMessage("[AuthMe] xAuth plugin not found");
            return;
        }
        File xAuthDb = new File(this.dataFolder.getParent(), FileUtils.makePath("xAuth", "xAuth.h2.db"));
        if (!xAuthDb.exists()) {
            sender.sendMessage("[AuthMe] xAuth H2 database not found, checking for MySQL or SQLite data...");
        }
        if (Utils.isCollectionEmpty(players = this.getXAuthPlayers())) {
            sender.sendMessage("[AuthMe] Error while importing xAuthPlayers: did not find any players");
            return;
        }
        sender.sendMessage("[AuthMe] Starting import...");
        for (int id : players) {
            String pl = this.getIdPlayer(id);
            String psw = this.getPassword(id);
            if (psw == null || psw.isEmpty() || pl == null) continue;
            PlayerAuth auth = PlayerAuth.builder().name(pl.toLowerCase(Locale.ROOT)).realName(pl).password(psw, null).build();
            this.database.saveAuth(auth);
        }
        sender.sendMessage("[AuthMe] Successfully converted from xAuth database");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getIdPlayer(int id) {
        String realPass = "";
        Connection conn = xAuth.getPlugin().getDatabaseController().getConnection();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = String.format("SELECT `playername` FROM `%s` WHERE `id` = ?", xAuth.getPlugin().getDatabaseController().getTable(DatabaseTables.ACCOUNT));
            ps = conn.prepareStatement(sql);
            ps.setInt(1, id);
            rs = ps.executeQuery();
            if (!rs.next()) {
                String string = null;
                xAuth.getPlugin().getDatabaseController().close(conn, ps, rs);
                return string;
            }
            realPass = rs.getString("playername").toLowerCase(Locale.ROOT);
            xAuth.getPlugin().getDatabaseController().close(conn, ps, rs);
        }
        catch (SQLException e) {
            xAuthLog.severe((String)("Failed to retrieve name for account: " + id), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            xAuth.getPlugin().getDatabaseController().close(conn, ps, rs);
        }
        return realPass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Integer> getXAuthPlayers() {
        ArrayList<Integer> xP = new ArrayList<Integer>();
        Connection conn = xAuth.getPlugin().getDatabaseController().getConnection();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = String.format("SELECT * FROM `%s`", xAuth.getPlugin().getDatabaseController().getTable(DatabaseTables.ACCOUNT));
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                xP.add(rs.getInt("id"));
            }
        }
        catch (SQLException e) {
            ArrayList<Integer> arrayList;
            try {
                xAuthLog.severe((String)"Cannot import xAuthPlayers", (Throwable)e);
                arrayList = new ArrayList<Integer>();
            }
            catch (Throwable throwable) {
                xAuth.getPlugin().getDatabaseController().close(conn, ps, rs);
                throw throwable;
            }
            xAuth.getPlugin().getDatabaseController().close(conn, ps, rs);
            return arrayList;
        }
        xAuth.getPlugin().getDatabaseController().close(conn, ps, rs);
        return xP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPassword(int accountId) {
        String realPass = "";
        Connection conn = xAuth.getPlugin().getDatabaseController().getConnection();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = String.format("SELECT `password`, `pwtype` FROM `%s` WHERE `id` = ?", xAuth.getPlugin().getDatabaseController().getTable(DatabaseTables.ACCOUNT));
            ps = conn.prepareStatement(sql);
            ps.setInt(1, accountId);
            rs = ps.executeQuery();
            if (!rs.next()) {
                String string = null;
                xAuth.getPlugin().getDatabaseController().close(conn, ps, rs);
                return string;
            }
            realPass = rs.getString("password");
            xAuth.getPlugin().getDatabaseController().close(conn, ps, rs);
        }
        catch (SQLException e) {
            xAuthLog.severe((String)("Failed to retrieve password hash for account: " + accountId), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            xAuth.getPlugin().getDatabaseController().close(conn, ps, rs);
        }
        return realPass;
    }
}

