/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.datasource.converter;

import fr.xephi.authme.AuthMe;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.data.auth.PlayerAuth;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.datasource.converter.Converter;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.util.FileUtils;
import java.io.File;
import java.util.Locale;
import javax.inject.Inject;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;

public class RoyalAuthConverter
implements Converter {
    private static final String LAST_LOGIN_PATH = "timestamps.quit";
    private static final String PASSWORD_PATH = "login.password";
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(RoyalAuthConverter.class);
    private final AuthMe plugin;
    private final DataSource dataSource;

    @Inject
    RoyalAuthConverter(AuthMe plugin, DataSource dataSource) {
        this.plugin = plugin;
        this.dataSource = dataSource;
    }

    @Override
    public void execute(CommandSender sender) {
        for (OfflinePlayer player : this.plugin.getServer().getOfflinePlayers()) {
            try {
                String name = player.getName().toLowerCase(Locale.ROOT);
                File file = new File(FileUtils.makePath(".", "plugins", "RoyalAuth", "userdata", name + ".yml"));
                if (this.dataSource.isAuthAvailable(name) || !file.exists()) continue;
                YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
                PlayerAuth auth = PlayerAuth.builder().name(name).password(configuration.getString(PASSWORD_PATH), null).lastLogin(configuration.getLong(LAST_LOGIN_PATH)).realName(player.getName()).build();
                this.dataSource.saveAuth(auth);
                this.dataSource.updateSession(auth);
            }
            catch (Exception e) {
                this.logger.logException("Error while trying to import " + player.getName() + " RoyalAuth data", e);
            }
        }
    }
}

