/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.datasource.converter;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.data.auth.PlayerAuth;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.datasource.DataSourceType;
import fr.xephi.authme.datasource.converter.Converter;
import fr.xephi.authme.datasource.converter.MySqlToSqlite;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.util.Utils;
import java.util.ArrayList;
import org.bukkit.command.CommandSender;

public abstract class AbstractDataSourceConverter<S extends DataSource>
implements Converter {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(MySqlToSqlite.class);
    private final DataSource destination;
    private final DataSourceType destinationType;

    public AbstractDataSourceConverter(DataSource destination, DataSourceType destinationType) {
        this.destination = destination;
        this.destinationType = destinationType;
    }

    @Override
    public void execute(CommandSender sender) {
        S source;
        if (this.destinationType != this.destination.getType()) {
            if (sender != null) {
                sender.sendMessage("Please configure your connection to " + String.valueOf((Object)this.destinationType) + " and re-run this command");
            }
            return;
        }
        try {
            source = this.getSource();
        }
        catch (Exception e) {
            Utils.logAndSendMessage(sender, "The data source to convert from could not be initialized");
            this.logger.logException("Could not initialize source:", e);
            return;
        }
        ArrayList<String> skippedPlayers = new ArrayList<String>();
        for (PlayerAuth auth : source.getAllAuths()) {
            if (this.destination.isAuthAvailable(auth.getNickname())) {
                skippedPlayers.add(auth.getNickname());
                continue;
            }
            this.destination.saveAuth(auth);
            this.destination.updateSession(auth);
            this.destination.updateQuitLoc(auth);
        }
        if (!skippedPlayers.isEmpty()) {
            Utils.logAndSendMessage(sender, "Skipped conversion for players which were already in " + String.valueOf((Object)this.destinationType) + ": " + String.join((CharSequence)", ", skippedPlayers));
        }
        Utils.logAndSendMessage(sender, "Database successfully converted from " + String.valueOf((Object)source.getType()) + " to " + String.valueOf((Object)this.destinationType));
    }

    protected abstract S getSource() throws Exception;
}

