/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.datasource.columnshandler;

import ch.jalu.datasourcecolumns.Column;
import ch.jalu.datasourcecolumns.DependentColumn;
import ch.jalu.datasourcecolumns.data.DataSourceValue;
import ch.jalu.datasourcecolumns.data.DataSourceValues;
import ch.jalu.datasourcecolumns.data.UpdateValues;
import ch.jalu.datasourcecolumns.predicate.Predicate;
import ch.jalu.datasourcecolumns.sqlimplementation.PredicateSqlGenerator;
import ch.jalu.datasourcecolumns.sqlimplementation.SqlColumnsHandler;
import ch.jalu.datasourcecolumns.sqlimplementation.SqlColumnsHandlerConfig;
import ch.jalu.datasourcecolumns.sqlimplementation.statementgenerator.ConnectionSupplier;
import fr.xephi.authme.data.auth.PlayerAuth;
import fr.xephi.authme.datasource.SqlDataSourceUtils;
import fr.xephi.authme.datasource.columnshandler.ColumnContext;
import fr.xephi.authme.datasource.columnshandler.DataSourceColumn;
import fr.xephi.authme.datasource.columnshandler.PlayerAuthColumn;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.DatabaseSettings;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;

public final class AuthMeColumnsHandler {
    private final SqlColumnsHandler<ColumnContext, String> internalHandler;

    private AuthMeColumnsHandler(SqlColumnsHandler<ColumnContext, String> internalHandler) {
        this.internalHandler = internalHandler;
    }

    public static AuthMeColumnsHandler createForSqlite(Connection connection, Settings settings) {
        ColumnContext columnContext = new ColumnContext(settings, false);
        String tableName = (String)settings.getProperty(DatabaseSettings.MYSQL_TABLE);
        String nameColumn = (String)settings.getProperty(DatabaseSettings.MYSQL_COL_NAME);
        SqlColumnsHandler sqlColHandler = new SqlColumnsHandler(SqlColumnsHandlerConfig.forSingleConnection((Connection)connection, (String)tableName, (String)nameColumn, (Object)columnContext).setPredicateSqlGenerator(new PredicateSqlGenerator((Object)columnContext, true)));
        return new AuthMeColumnsHandler((SqlColumnsHandler<ColumnContext, String>)sqlColHandler);
    }

    public static AuthMeColumnsHandler createForMySql(ConnectionSupplier connectionSupplier, Settings settings) {
        ColumnContext columnContext = new ColumnContext(settings, true);
        String tableName = (String)settings.getProperty(DatabaseSettings.MYSQL_TABLE);
        String nameColumn = (String)settings.getProperty(DatabaseSettings.MYSQL_COL_NAME);
        SqlColumnsHandler sqlColHandler = new SqlColumnsHandler(SqlColumnsHandlerConfig.forConnectionPool((ConnectionSupplier)connectionSupplier, (String)tableName, (String)nameColumn, (Object)columnContext));
        return new AuthMeColumnsHandler((SqlColumnsHandler<ColumnContext, String>)sqlColHandler);
    }

    public <T> boolean update(String name, DataSourceColumn<T> column, T value) {
        try {
            return this.internalHandler.update((Object)name.toLowerCase(Locale.ROOT), column, value);
        }
        catch (SQLException e) {
            SqlDataSourceUtils.logSqlException(e);
            return false;
        }
    }

    public boolean update(PlayerAuth auth, PlayerAuthColumn<?> ... columns) {
        try {
            return this.internalHandler.update((Object)auth.getNickname(), (Object)auth, (DependentColumn[])columns);
        }
        catch (SQLException e) {
            SqlDataSourceUtils.logSqlException(e);
            return false;
        }
    }

    public boolean update(String name, UpdateValues<ColumnContext> updateValues) {
        try {
            return this.internalHandler.update((Object)name.toLowerCase(Locale.ROOT), updateValues);
        }
        catch (SQLException e) {
            SqlDataSourceUtils.logSqlException(e);
            return false;
        }
    }

    public <T> int update(Predicate<ColumnContext> predicate, DataSourceColumn<T> column, T value) {
        try {
            return this.internalHandler.update(predicate, column, value);
        }
        catch (SQLException e) {
            SqlDataSourceUtils.logSqlException(e);
            return 0;
        }
    }

    public <T> DataSourceValue<T> retrieve(String name, DataSourceColumn<T> column) throws SQLException {
        return this.internalHandler.retrieve((Object)name.toLowerCase(Locale.ROOT), column);
    }

    public DataSourceValues retrieve(String name, DataSourceColumn<?> ... columns) throws SQLException {
        return this.internalHandler.retrieve((Object)name.toLowerCase(Locale.ROOT), (Column[])columns);
    }

    public <T> List<T> retrieve(Predicate<ColumnContext> predicate, DataSourceColumn<T> column) throws SQLException {
        return this.internalHandler.retrieve(predicate, column);
    }

    public boolean insert(PlayerAuth auth, PlayerAuthColumn<?> ... columns) {
        try {
            return this.internalHandler.insert((Object)auth, (DependentColumn[])columns);
        }
        catch (SQLException e) {
            SqlDataSourceUtils.logSqlException(e);
            return false;
        }
    }

    public int count(Predicate<ColumnContext> predicate) {
        try {
            return this.internalHandler.count(predicate);
        }
        catch (SQLException e) {
            SqlDataSourceUtils.logSqlException(e);
            return 0;
        }
    }
}

