/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.datasource.columnshandler;

import ch.jalu.configme.properties.Property;
import ch.jalu.datasourcecolumns.ColumnType;
import ch.jalu.datasourcecolumns.StandardTypes;
import fr.xephi.authme.data.auth.PlayerAuth;
import fr.xephi.authme.datasource.columnshandler.DataSourceColumn;
import fr.xephi.authme.datasource.columnshandler.PlayerAuthColumn;
import java.util.function.Function;

final class AuthMeColumnsFactory {
    private AuthMeColumnsFactory() {
    }

    static DataSourceColumn<Integer> createInteger(Property<String> nameProperty, ColumnOptions ... options) {
        return new DataSourceColumn<Integer>(StandardTypes.INTEGER, nameProperty, AuthMeColumnsFactory.isOptional(options), AuthMeColumnsFactory.hasDefaultForNull(options));
    }

    static PlayerAuthColumn<Integer> createInteger(Property<String> nameProperty, Function<PlayerAuth, Integer> playerAuthGetter, ColumnOptions ... options) {
        return AuthMeColumnsFactory.createInternal(StandardTypes.INTEGER, nameProperty, playerAuthGetter, options);
    }

    static PlayerAuthColumn<Long> createLong(Property<String> nameProperty, Function<PlayerAuth, Long> playerAuthGetter, ColumnOptions ... options) {
        return AuthMeColumnsFactory.createInternal(StandardTypes.LONG, nameProperty, playerAuthGetter, options);
    }

    static PlayerAuthColumn<String> createString(Property<String> nameProperty, Function<PlayerAuth, String> playerAuthGetter, ColumnOptions ... options) {
        return AuthMeColumnsFactory.createInternal(StandardTypes.STRING, nameProperty, playerAuthGetter, options);
    }

    static PlayerAuthColumn<Double> createDouble(Property<String> nameProperty, Function<PlayerAuth, Double> playerAuthGetter, ColumnOptions ... options) {
        return AuthMeColumnsFactory.createInternal(StandardTypes.DOUBLE, nameProperty, playerAuthGetter, options);
    }

    static PlayerAuthColumn<Float> createFloat(Property<String> nameProperty, Function<PlayerAuth, Float> playerAuthGetter, ColumnOptions ... options) {
        return AuthMeColumnsFactory.createInternal(StandardTypes.FLOAT, nameProperty, playerAuthGetter, options);
    }

    private static <T> PlayerAuthColumn<T> createInternal(ColumnType<T> type, Property<String> nameProperty, Function<PlayerAuth, T> authGetter, ColumnOptions ... options) {
        return new PlayerAuthColumn<T>(type, nameProperty, AuthMeColumnsFactory.isOptional(options), AuthMeColumnsFactory.hasDefaultForNull(options), authGetter);
    }

    private static boolean isOptional(ColumnOptions[] options) {
        return AuthMeColumnsFactory.containsInArray(ColumnOptions.OPTIONAL, options);
    }

    private static boolean hasDefaultForNull(ColumnOptions[] options) {
        return AuthMeColumnsFactory.containsInArray(ColumnOptions.DEFAULT_FOR_NULL, options);
    }

    private static boolean containsInArray(ColumnOptions needle, ColumnOptions[] haystack) {
        for (ColumnOptions option : haystack) {
            if (option != needle) continue;
            return true;
        }
        return false;
    }

    static enum ColumnOptions {
        OPTIONAL,
        DEFAULT_FOR_NULL;

    }
}

