/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.datasource;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class SqlDataSourceUtils {
    private static final ConsoleLogger logger = ConsoleLoggerFactory.get(SqlDataSourceUtils.class);

    private SqlDataSourceUtils() {
    }

    public static void logSqlException(SQLException e) {
        logger.logException("Error during SQL operation:", e);
    }

    public static Long getNullableLong(ResultSet rs, String columnName) throws SQLException {
        long longValue = rs.getLong(columnName);
        return rs.wasNull() ? null : Long.valueOf(longValue);
    }

    public static boolean isNotNullColumn(DatabaseMetaData metaData, String tableName, String columnName) throws SQLException {
        try (ResultSet rs = metaData.getColumns(null, null, tableName, columnName);){
            if (!rs.next()) {
                throw new IllegalStateException("Did not find meta data for column '" + columnName + "' while checking for not-null constraint");
            }
            int nullableCode = rs.getInt("NULLABLE");
            if (nullableCode == 0) {
                boolean bl = true;
                return bl;
            }
            if (nullableCode == 2) {
                logger.warning("Unknown nullable status for column '" + columnName + "'");
            }
        }
        return false;
    }

    public static Object getColumnDefaultValue(DatabaseMetaData metaData, String tableName, String columnName) throws SQLException {
        try (ResultSet rs = metaData.getColumns(null, null, tableName, columnName);){
            if (!rs.next()) {
                throw new IllegalStateException("Did not find meta data for column '" + columnName + "' while checking its default value");
            }
            Object object = rs.getObject("COLUMN_DEF");
            return object;
        }
    }

    public static int getColumnSize(DatabaseMetaData metaData, String tableName, String columnName) throws SQLException {
        try (ResultSet rs = metaData.getColumns(null, null, tableName, columnName);){
            if (!rs.next()) {
                throw new IllegalStateException("Did not find meta data for column '" + columnName + "' while checking its size");
            }
            int n = rs.getInt("COLUMN_SIZE");
            return n;
        }
    }
}

