/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.datasource;

import com.google.common.annotations.VisibleForTesting;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.data.auth.PlayerAuth;
import fr.xephi.authme.datasource.AbstractSqlDataSource;
import fr.xephi.authme.datasource.Columns;
import fr.xephi.authme.datasource.DataSourceType;
import fr.xephi.authme.datasource.SqLiteMigrater;
import fr.xephi.authme.datasource.SqlDataSourceUtils;
import fr.xephi.authme.datasource.columnshandler.AuthMeColumnsHandler;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.DatabaseSettings;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class SQLite
extends AbstractSqlDataSource {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(SQLite.class);
    private final Settings settings;
    private final File dataFolder;
    private final String database;
    private final String tableName;
    private final Columns col;
    private Connection con;

    public SQLite(Settings settings, File dataFolder) throws SQLException {
        this.settings = settings;
        this.dataFolder = dataFolder;
        this.database = (String)settings.getProperty(DatabaseSettings.MYSQL_DATABASE);
        this.tableName = (String)settings.getProperty(DatabaseSettings.MYSQL_TABLE);
        this.col = new Columns(settings);
        try {
            this.connect();
            this.setup();
            this.migrateIfNeeded();
        }
        catch (Exception ex) {
            this.logger.logException("Error during SQLite initialization:", ex);
            throw ex;
        }
    }

    @VisibleForTesting
    SQLite(Settings settings, File dataFolder, Connection connection) {
        this.settings = settings;
        this.dataFolder = dataFolder;
        this.database = (String)settings.getProperty(DatabaseSettings.MYSQL_DATABASE);
        this.tableName = (String)settings.getProperty(DatabaseSettings.MYSQL_TABLE);
        this.col = new Columns(settings);
        this.con = connection;
        this.columnsHandler = AuthMeColumnsHandler.createForSqlite(this.con, settings);
    }

    protected void connect() throws SQLException {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to load SQLite JDBC class", e);
        }
        this.logger.debug("SQLite driver loaded");
        this.con = DriverManager.getConnection(this.getJdbcUrl(this.dataFolder.getAbsolutePath(), "", this.database));
        this.columnsHandler = AuthMeColumnsHandler.createForSqlite(this.con, this.settings);
    }

    @VisibleForTesting
    protected void setup() throws SQLException {
        try (Statement st = this.con.createStatement();){
            st.executeUpdate("CREATE TABLE IF NOT EXISTS " + this.tableName + " (" + this.col.ID + " INTEGER AUTO_INCREMENT, " + this.col.NAME + " VARCHAR(255) NOT NULL UNIQUE, CONSTRAINT table_const_prim PRIMARY KEY (" + this.col.ID + "));");
            DatabaseMetaData md = this.con.getMetaData();
            if (this.isColumnMissing(md, this.col.REAL_NAME)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.REAL_NAME + " VARCHAR(255) NOT NULL DEFAULT 'Player';");
            }
            if (this.isColumnMissing(md, this.col.PASSWORD)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.PASSWORD + " VARCHAR(255) NOT NULL DEFAULT '';");
            }
            if (!this.col.SALT.isEmpty() && this.isColumnMissing(md, this.col.SALT)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.SALT + " VARCHAR(255);");
            }
            if (this.isColumnMissing(md, this.col.LAST_IP)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.LAST_IP + " VARCHAR(40);");
            }
            if (this.isColumnMissing(md, this.col.LAST_LOGIN)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.LAST_LOGIN + " TIMESTAMP;");
            }
            if (this.isColumnMissing(md, this.col.REGISTRATION_IP)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.REGISTRATION_IP + " VARCHAR(40);");
            }
            if (this.isColumnMissing(md, this.col.REGISTRATION_DATE)) {
                this.addRegistrationDateColumn(st);
            }
            if (this.isColumnMissing(md, this.col.LASTLOC_X)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.LASTLOC_X + " DOUBLE NOT NULL DEFAULT '0.0';");
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.LASTLOC_Y + " DOUBLE NOT NULL DEFAULT '0.0';");
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.LASTLOC_Z + " DOUBLE NOT NULL DEFAULT '0.0';");
            }
            if (this.isColumnMissing(md, this.col.LASTLOC_WORLD)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.LASTLOC_WORLD + " VARCHAR(255) NOT NULL DEFAULT 'world';");
            }
            if (this.isColumnMissing(md, this.col.LASTLOC_YAW)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.LASTLOC_YAW + " FLOAT;");
            }
            if (this.isColumnMissing(md, this.col.LASTLOC_PITCH)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.LASTLOC_PITCH + " FLOAT;");
            }
            if (this.isColumnMissing(md, this.col.EMAIL)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.EMAIL + " VARCHAR(255);");
            }
            if (this.isColumnMissing(md, this.col.IS_LOGGED)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.IS_LOGGED + " INT NOT NULL DEFAULT '0';");
            }
            if (this.isColumnMissing(md, this.col.HAS_SESSION)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.HAS_SESSION + " INT NOT NULL DEFAULT '0';");
            }
            if (this.isColumnMissing(md, this.col.TOTP_KEY)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.TOTP_KEY + " VARCHAR(32);");
            }
            if (!this.col.PLAYER_UUID.isEmpty() && this.isColumnMissing(md, this.col.PLAYER_UUID)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.PLAYER_UUID + " VARCHAR(36)");
            }
        }
        this.logger.info("SQLite Setup finished");
    }

    @VisibleForTesting
    void migrateIfNeeded() throws SQLException {
        DatabaseMetaData metaData = this.con.getMetaData();
        if (SqLiteMigrater.isMigrationRequired(metaData, this.tableName, this.col)) {
            new SqLiteMigrater(this.settings, this.dataFolder).performMigration(this);
            this.connect();
        }
    }

    private boolean isColumnMissing(DatabaseMetaData metaData, String columnName) throws SQLException {
        try (ResultSet rs = metaData.getColumns(null, null, this.tableName, columnName);){
            boolean bl = !rs.next();
            return bl;
        }
    }

    @Override
    public void reload() {
        SQLite.close(this.con);
        try {
            this.connect();
            this.setup();
            this.migrateIfNeeded();
        }
        catch (SQLException ex) {
            this.logger.logException("Error while reloading SQLite:", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PlayerAuth getAuth(String user) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE LOWER(" + this.col.NAME + ")=LOWER(?);";
        try (PreparedStatement pst = this.con.prepareStatement(sql);){
            pst.setString(1, user);
            try (ResultSet rs = pst.executeQuery();){
                if (!rs.next()) return null;
                PlayerAuth playerAuth = this.buildAuthFromResultSet(rs);
                return playerAuth;
            }
        }
        catch (SQLException ex) {
            SqlDataSourceUtils.logSqlException(ex);
        }
        return null;
    }

    @Override
    public Set<String> getRecordsToPurge(long until) {
        HashSet<String> list = new HashSet<String>();
        String select = "SELECT " + this.col.NAME + " FROM " + this.tableName + " WHERE MAX( COALESCE(" + this.col.LAST_LOGIN + ", 0), COALESCE(" + this.col.REGISTRATION_DATE + ", 0)) < ?;";
        try (PreparedStatement selectPst = this.con.prepareStatement(select);){
            selectPst.setLong(1, until);
            try (ResultSet rs = selectPst.executeQuery();){
                while (rs.next()) {
                    list.add(rs.getString(this.col.NAME));
                }
            }
        }
        catch (SQLException ex) {
            SqlDataSourceUtils.logSqlException(ex);
        }
        return list;
    }

    @Override
    public void purgeRecords(Collection<String> toPurge) {
        String delete = "DELETE FROM " + this.tableName + " WHERE " + this.col.NAME + "=?;";
        try (PreparedStatement deletePst = this.con.prepareStatement(delete);){
            for (String name : toPurge) {
                deletePst.setString(1, name.toLowerCase(Locale.ROOT));
                deletePst.executeUpdate();
            }
        }
        catch (SQLException ex) {
            SqlDataSourceUtils.logSqlException(ex);
        }
    }

    @Override
    public boolean removeAuth(String user) {
        boolean bl;
        block8: {
            String sql = "DELETE FROM " + this.tableName + " WHERE " + this.col.NAME + "=?;";
            PreparedStatement pst = this.con.prepareStatement(sql);
            try {
                pst.setString(1, user.toLowerCase(Locale.ROOT));
                pst.executeUpdate();
                bl = true;
                if (pst == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pst != null) {
                        try {
                            pst.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    SqlDataSourceUtils.logSqlException(ex);
                    return false;
                }
            }
            pst.close();
        }
        return bl;
    }

    @Override
    public void closeConnection() {
        try {
            if (this.con != null && !this.con.isClosed()) {
                this.con.close();
            }
        }
        catch (SQLException ex) {
            SqlDataSourceUtils.logSqlException(ex);
        }
    }

    @Override
    public DataSourceType getType() {
        return DataSourceType.SQLITE;
    }

    @Override
    public List<PlayerAuth> getAllAuths() {
        ArrayList<PlayerAuth> auths = new ArrayList<PlayerAuth>();
        String sql = "SELECT * FROM " + this.tableName + ";";
        try (PreparedStatement pst = this.con.prepareStatement(sql);
             ResultSet rs = pst.executeQuery();){
            while (rs.next()) {
                PlayerAuth auth = this.buildAuthFromResultSet(rs);
                auths.add(auth);
            }
        }
        catch (SQLException ex) {
            SqlDataSourceUtils.logSqlException(ex);
        }
        return auths;
    }

    @Override
    public List<String> getLoggedPlayersWithEmptyMail() {
        ArrayList<String> players = new ArrayList<String>();
        String sql = "SELECT " + this.col.REAL_NAME + " FROM " + this.tableName + " WHERE " + this.col.IS_LOGGED + " = 1 AND (" + this.col.EMAIL + " = 'your@email.com' OR " + this.col.EMAIL + " IS NULL);";
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(sql);){
            while (rs.next()) {
                players.add(rs.getString(1));
            }
        }
        catch (SQLException ex) {
            SqlDataSourceUtils.logSqlException(ex);
        }
        return players;
    }

    @Override
    public List<PlayerAuth> getRecentlyLoggedInPlayers() {
        ArrayList<PlayerAuth> players = new ArrayList<PlayerAuth>();
        String sql = "SELECT * FROM " + this.tableName + " ORDER BY " + this.col.LAST_LOGIN + " DESC LIMIT 10;";
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(sql);){
            while (rs.next()) {
                players.add(this.buildAuthFromResultSet(rs));
            }
        }
        catch (SQLException e) {
            SqlDataSourceUtils.logSqlException(e);
        }
        return players;
    }

    @Override
    public boolean setTotpKey(String user, String totpKey) {
        boolean bl;
        block8: {
            String sql = "UPDATE " + this.tableName + " SET " + this.col.TOTP_KEY + " = ? WHERE " + this.col.NAME + " = ?";
            PreparedStatement pst = this.con.prepareStatement(sql);
            try {
                pst.setString(1, totpKey);
                pst.setString(2, user.toLowerCase(Locale.ROOT));
                pst.executeUpdate();
                bl = true;
                if (pst == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pst != null) {
                        try {
                            pst.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    SqlDataSourceUtils.logSqlException(e);
                    return false;
                }
            }
            pst.close();
        }
        return bl;
    }

    private PlayerAuth buildAuthFromResultSet(ResultSet row) throws SQLException {
        String salt = !this.col.SALT.isEmpty() ? row.getString(this.col.SALT) : null;
        return PlayerAuth.builder().name(row.getString(this.col.NAME)).email(row.getString(this.col.EMAIL)).realName(row.getString(this.col.REAL_NAME)).password(row.getString(this.col.PASSWORD), salt).totpKey(row.getString(this.col.TOTP_KEY)).lastLogin(SqlDataSourceUtils.getNullableLong(row, this.col.LAST_LOGIN)).lastIp(row.getString(this.col.LAST_IP)).registrationDate(row.getLong(this.col.REGISTRATION_DATE)).registrationIp(row.getString(this.col.REGISTRATION_IP)).locX(row.getDouble(this.col.LASTLOC_X)).locY(row.getDouble(this.col.LASTLOC_Y)).locZ(row.getDouble(this.col.LASTLOC_Z)).locWorld(row.getString(this.col.LASTLOC_WORLD)).locYaw(row.getFloat(this.col.LASTLOC_YAW)).locPitch(row.getFloat(this.col.LASTLOC_PITCH)).build();
    }

    private void addRegistrationDateColumn(Statement st) throws SQLException {
        st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.REGISTRATION_DATE + " TIMESTAMP NOT NULL DEFAULT '0';");
        long currentTimestamp = System.currentTimeMillis();
        int updatedRows = st.executeUpdate(String.format("UPDATE %s SET %s = %d;", this.tableName, this.col.REGISTRATION_DATE, currentTimestamp));
        this.logger.info("Created column '" + this.col.REGISTRATION_DATE + "' and set the current timestamp, " + currentTimestamp + ", to all " + updatedRows + " rows");
    }

    @Override
    String getJdbcUrl(String dataPath, String ignored, String database) {
        return "jdbc:sqlite:" + dataPath + File.separator + database + ".db";
    }

    private static void close(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException ex) {
                SqlDataSourceUtils.logSqlException(ex);
            }
        }
    }
}

