/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.datasource;

import com.google.common.annotations.VisibleForTesting;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.pool.HikariPool;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.data.auth.PlayerAuth;
import fr.xephi.authme.datasource.AbstractSqlDataSource;
import fr.xephi.authme.datasource.Columns;
import fr.xephi.authme.datasource.DataSourceType;
import fr.xephi.authme.datasource.MySqlMigrater;
import fr.xephi.authme.datasource.SqlDataSourceUtils;
import fr.xephi.authme.datasource.columnshandler.AuthMeColumnsHandler;
import fr.xephi.authme.datasource.mysqlextensions.MySqlExtension;
import fr.xephi.authme.datasource.mysqlextensions.MySqlExtensionsFactory;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.DatabaseSettings;
import fr.xephi.authme.settings.properties.HooksSettings;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class PostgreSqlDataSource
extends AbstractSqlDataSource {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(PostgreSqlDataSource.class);
    private String host;
    private String port;
    private String username;
    private String password;
    private String database;
    private String tableName;
    private int poolSize;
    private int maxLifetime;
    private List<String> columnOthers;
    private Columns col;
    private MySqlExtension sqlExtension;
    private HikariDataSource ds;

    public PostgreSqlDataSource(Settings settings, MySqlExtensionsFactory extensionsFactory) throws SQLException {
        this.setParameters(settings, extensionsFactory);
        try {
            this.setConnectionArguments();
        }
        catch (RuntimeException e) {
            if (e instanceof IllegalArgumentException) {
                this.logger.warning("Invalid database arguments! Please check your configuration!");
                this.logger.warning("If this error persists, please report it to the developer!");
            }
            if (e instanceof HikariPool.PoolInitializationException) {
                this.logger.warning("Can't initialize database connection! Please check your configuration!");
                this.logger.warning("If this error persists, please report it to the developer!");
            }
            this.logger.warning("Can't use the Hikari Connection Pool! Please, report this error to the developer!");
            throw e;
        }
        try {
            this.checkTablesAndColumns();
        }
        catch (SQLException e) {
            this.closeConnection();
            this.logger.logException("Can't initialize the PostgreSQL database:", e);
            this.logger.warning("Please check your database settings in the config.yml file!");
            throw e;
        }
    }

    @VisibleForTesting
    PostgreSqlDataSource(Settings settings, HikariDataSource hikariDataSource, MySqlExtensionsFactory extensionsFactory) {
        this.ds = hikariDataSource;
        this.setParameters(settings, extensionsFactory);
    }

    private void setParameters(Settings settings, MySqlExtensionsFactory extensionsFactory) {
        this.host = (String)settings.getProperty(DatabaseSettings.MYSQL_HOST);
        this.port = (String)settings.getProperty(DatabaseSettings.MYSQL_PORT);
        this.username = (String)settings.getProperty(DatabaseSettings.MYSQL_USERNAME);
        this.password = (String)settings.getProperty(DatabaseSettings.MYSQL_PASSWORD);
        this.database = (String)settings.getProperty(DatabaseSettings.MYSQL_DATABASE);
        this.tableName = (String)settings.getProperty(DatabaseSettings.MYSQL_TABLE);
        this.columnOthers = (List)settings.getProperty(HooksSettings.MYSQL_OTHER_USERNAME_COLS);
        this.col = new Columns(settings);
        this.columnsHandler = AuthMeColumnsHandler.createForMySql(this::getConnection, settings);
        this.sqlExtension = extensionsFactory.buildExtension(this.col);
        this.poolSize = (Integer)settings.getProperty(DatabaseSettings.MYSQL_POOL_SIZE);
        this.maxLifetime = (Integer)settings.getProperty(DatabaseSettings.MYSQL_CONNECTION_MAX_LIFETIME);
    }

    private void setConnectionArguments() {
        this.ds = new HikariDataSource();
        this.ds.setPoolName("AuthMePostgreSQLPool");
        this.ds.setMaximumPoolSize(this.poolSize);
        this.ds.setMaxLifetime((long)(this.maxLifetime * 1000));
        this.ds.setDriverClassName("org.postgresql.Driver");
        this.ds.setJdbcUrl(this.getJdbcUrl(this.host, this.port, this.database));
        this.ds.setUsername(this.username);
        this.ds.setPassword(this.password);
        this.ds.addDataSourceProperty("reWriteBatchedInserts", (Object)"true");
        this.ds.addDataSourceProperty("cachePrepStmts", (Object)"true");
        this.ds.addDataSourceProperty("preparedStatementCacheQueries", (Object)"275");
        this.logger.info("Connection arguments loaded, Hikari ConnectionPool ready!");
    }

    @Override
    public void reload() {
        if (this.ds != null) {
            this.ds.close();
        }
        this.setConnectionArguments();
        this.logger.info("Hikari ConnectionPool arguments reloaded!");
    }

    private Connection getConnection() throws SQLException {
        return this.ds.getConnection();
    }

    private void checkTablesAndColumns() throws SQLException {
        try (Connection con = this.getConnection();
             Statement st = con.createStatement();){
            String sql = "CREATE TABLE IF NOT EXISTS " + this.tableName + " (" + this.col.ID + " BIGSERIAL,PRIMARY KEY (" + this.col.ID + "));";
            st.executeUpdate(sql);
            DatabaseMetaData md = con.getMetaData();
            if (this.isColumnMissing(md, this.col.NAME)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.NAME + " VARCHAR(255) NOT NULL UNIQUE;");
            }
            if (this.isColumnMissing(md, this.col.REAL_NAME)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.REAL_NAME + " VARCHAR(255) NOT NULL;");
            }
            if (this.isColumnMissing(md, this.col.PASSWORD)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.PASSWORD + " VARCHAR(255) NOT NULL;");
            }
            if (!this.col.SALT.isEmpty() && this.isColumnMissing(md, this.col.SALT)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.SALT + " VARCHAR(255);");
            }
            if (this.isColumnMissing(md, this.col.LAST_IP)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.LAST_IP + " VARCHAR(40);");
            } else {
                MySqlMigrater.migrateLastIpColumn(st, md, this.tableName, this.col);
            }
            if (this.isColumnMissing(md, this.col.LAST_LOGIN)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.LAST_LOGIN + " BIGINT;");
            } else {
                MySqlMigrater.migrateLastLoginColumn(st, md, this.tableName, this.col);
            }
            if (this.isColumnMissing(md, this.col.REGISTRATION_DATE)) {
                MySqlMigrater.addRegistrationDateColumn(st, this.tableName, this.col);
            }
            if (this.isColumnMissing(md, this.col.REGISTRATION_IP)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.REGISTRATION_IP + " VARCHAR(40);");
            }
            if (this.isColumnMissing(md, this.col.LASTLOC_X)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.LASTLOC_X + " DOUBLE PRECISION NOT NULL DEFAULT '0.0' , ADD " + this.col.LASTLOC_Y + " DOUBLE PRECISION NOT NULL DEFAULT '0.0' , ADD " + this.col.LASTLOC_Z + " DOUBLE PRECISION NOT NULL DEFAULT '0.0';");
            }
            if (this.isColumnMissing(md, this.col.LASTLOC_WORLD)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.LASTLOC_WORLD + " VARCHAR(255) NOT NULL DEFAULT 'world';");
            }
            if (this.isColumnMissing(md, this.col.LASTLOC_YAW)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.LASTLOC_YAW + " FLOAT;");
            }
            if (this.isColumnMissing(md, this.col.LASTLOC_PITCH)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.LASTLOC_PITCH + " FLOAT;");
            }
            if (this.isColumnMissing(md, this.col.EMAIL)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.EMAIL + " VARCHAR(255);");
            }
            if (this.isColumnMissing(md, this.col.IS_LOGGED)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.IS_LOGGED + " SMALLINT NOT NULL DEFAULT '0';");
            }
            if (this.isColumnMissing(md, this.col.HAS_SESSION)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.HAS_SESSION + " SMALLINT NOT NULL DEFAULT '0';");
            }
            if (this.isColumnMissing(md, this.col.TOTP_KEY)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.TOTP_KEY + " VARCHAR(32);");
            } else if (SqlDataSourceUtils.getColumnSize(md, this.tableName, this.col.TOTP_KEY) != 32) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ALTER COLUMN " + this.col.TOTP_KEY + " TYPE VARCHAR(32);");
            }
            if (!this.col.PLAYER_UUID.isEmpty() && this.isColumnMissing(md, this.col.PLAYER_UUID)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.PLAYER_UUID + " VARCHAR(36)");
            }
        }
        this.logger.info("PostgreSQL setup finished");
    }

    private boolean isColumnMissing(DatabaseMetaData metaData, String columnName) throws SQLException {
        try (ResultSet rs = metaData.getColumns(null, null, this.tableName, columnName.toLowerCase(Locale.ROOT));){
            boolean bl = !rs.next();
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PlayerAuth getAuth(String user) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE " + this.col.NAME + "=?;";
        try (Connection con = this.getConnection();
             PreparedStatement pst = con.prepareStatement(sql);){
            pst.setString(1, user.toLowerCase(Locale.ROOT));
            try (ResultSet rs = pst.executeQuery();){
                if (!rs.next()) return null;
                int id = rs.getInt(this.col.ID);
                PlayerAuth auth = this.buildAuthFromResultSet(rs);
                this.sqlExtension.extendAuth(auth, id, con);
                PlayerAuth playerAuth = auth;
                return playerAuth;
            }
        }
        catch (SQLException ex) {
            SqlDataSourceUtils.logSqlException(ex);
        }
        return null;
    }

    @Override
    public boolean saveAuth(PlayerAuth auth) {
        boolean bl;
        block16: {
            super.saveAuth(auth);
            Connection con = this.getConnection();
            try {
                if (!this.columnOthers.isEmpty()) {
                    for (String column : this.columnOthers) {
                        try (PreparedStatement pst = con.prepareStatement("UPDATE " + this.tableName + " SET " + column + "=? WHERE " + this.col.NAME + "=?;");){
                            pst.setString(1, auth.getRealName());
                            pst.setString(2, auth.getNickname());
                            pst.executeUpdate();
                        }
                    }
                }
                this.sqlExtension.saveAuth(auth, con);
                bl = true;
                if (con == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    SqlDataSourceUtils.logSqlException(ex);
                    return false;
                }
            }
            con.close();
        }
        return bl;
    }

    @Override
    String getJdbcUrl(String host, String port, String database) {
        return "jdbc:postgresql://" + host + ":" + port + "/" + database;
    }

    @Override
    public Set<String> getRecordsToPurge(long until) {
        HashSet<String> list = new HashSet<String>();
        String select = "SELECT " + this.col.NAME + " FROM " + this.tableName + " WHERE GREATEST( COALESCE(" + this.col.LAST_LOGIN + ", 0), COALESCE(" + this.col.REGISTRATION_DATE + ", 0)) < ?;";
        try (Connection con = this.getConnection();
             PreparedStatement selectPst = con.prepareStatement(select);){
            selectPst.setLong(1, until);
            try (ResultSet rs = selectPst.executeQuery();){
                while (rs.next()) {
                    list.add(rs.getString(this.col.NAME));
                }
            }
        }
        catch (SQLException ex) {
            SqlDataSourceUtils.logSqlException(ex);
        }
        return list;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean removeAuth(String user) {
        user = user.toLowerCase(Locale.ROOT);
        String sql = "DELETE FROM " + this.tableName + " WHERE " + this.col.NAME + "=?;";
        try (Connection con = this.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement pst = con.prepareStatement(sql);
                try {
                    this.sqlExtension.removeAuth(user, con);
                    pst.setString(1, user.toLowerCase(Locale.ROOT));
                    pst.executeUpdate();
                    bl = true;
                    if (pst == null) break block14;
                }
                catch (Throwable throwable) {
                    if (pst != null) {
                        try {
                            pst.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pst.close();
            }
            return bl;
        }
        catch (SQLException ex) {
            SqlDataSourceUtils.logSqlException(ex);
            return false;
        }
    }

    @Override
    public void closeConnection() {
        if (this.ds != null && !this.ds.isClosed()) {
            this.ds.close();
        }
    }

    @Override
    public void purgeRecords(Collection<String> toPurge) {
        String sql = "DELETE FROM " + this.tableName + " WHERE " + this.col.NAME + "=?;";
        try (Connection con = this.getConnection();
             PreparedStatement pst = con.prepareStatement(sql);){
            for (String name : toPurge) {
                pst.setString(1, name.toLowerCase(Locale.ROOT));
                pst.executeUpdate();
            }
        }
        catch (SQLException ex) {
            SqlDataSourceUtils.logSqlException(ex);
        }
    }

    @Override
    public DataSourceType getType() {
        return DataSourceType.POSTGRESQL;
    }

    @Override
    public List<PlayerAuth> getAllAuths() {
        ArrayList<PlayerAuth> auths = new ArrayList<PlayerAuth>();
        try (Connection con = this.getConnection();
             Statement st = con.createStatement();
             ResultSet rs = st.executeQuery("SELECT * FROM " + this.tableName);){
            while (rs.next()) {
                PlayerAuth auth = this.buildAuthFromResultSet(rs);
                this.sqlExtension.extendAuth(auth, rs.getInt(this.col.ID), con);
                auths.add(auth);
            }
        }
        catch (SQLException ex) {
            SqlDataSourceUtils.logSqlException(ex);
        }
        return auths;
    }

    @Override
    public List<String> getLoggedPlayersWithEmptyMail() {
        ArrayList<String> players = new ArrayList<String>();
        String sql = "SELECT " + this.col.REAL_NAME + " FROM " + this.tableName + " WHERE " + this.col.IS_LOGGED + " = 1 AND (" + this.col.EMAIL + " = 'your@email.com' OR " + this.col.EMAIL + " IS NULL);";
        try (Connection con = this.getConnection();
             Statement st = con.createStatement();
             ResultSet rs = st.executeQuery(sql);){
            while (rs.next()) {
                players.add(rs.getString(1));
            }
        }
        catch (SQLException ex) {
            SqlDataSourceUtils.logSqlException(ex);
        }
        return players;
    }

    @Override
    public List<PlayerAuth> getRecentlyLoggedInPlayers() {
        ArrayList<PlayerAuth> players = new ArrayList<PlayerAuth>();
        String sql = "SELECT * FROM " + this.tableName + " ORDER BY " + this.col.LAST_LOGIN + " DESC LIMIT 10;";
        try (Connection con = this.getConnection();
             Statement st = con.createStatement();
             ResultSet rs = st.executeQuery(sql);){
            while (rs.next()) {
                players.add(this.buildAuthFromResultSet(rs));
            }
        }
        catch (SQLException e) {
            SqlDataSourceUtils.logSqlException(e);
        }
        return players;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setTotpKey(String user, String totpKey) {
        String sql = "UPDATE " + this.tableName + " SET " + this.col.TOTP_KEY + " = ? WHERE " + this.col.NAME + " = ?";
        try (Connection con = this.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement pst = con.prepareStatement(sql);
                try {
                    pst.setString(1, totpKey);
                    pst.setString(2, user.toLowerCase(Locale.ROOT));
                    pst.executeUpdate();
                    bl = true;
                    if (pst == null) break block14;
                }
                catch (Throwable throwable) {
                    if (pst != null) {
                        try {
                            pst.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pst.close();
            }
            return bl;
        }
        catch (SQLException e) {
            SqlDataSourceUtils.logSqlException(e);
            return false;
        }
    }

    private PlayerAuth buildAuthFromResultSet(ResultSet row) throws SQLException {
        String salt = this.col.SALT.isEmpty() ? null : row.getString(this.col.SALT);
        int group = this.col.GROUP.isEmpty() ? -1 : row.getInt(this.col.GROUP);
        return PlayerAuth.builder().name(row.getString(this.col.NAME)).realName(row.getString(this.col.REAL_NAME)).password(row.getString(this.col.PASSWORD), salt).totpKey(row.getString(this.col.TOTP_KEY)).lastLogin(SqlDataSourceUtils.getNullableLong(row, this.col.LAST_LOGIN)).lastIp(row.getString(this.col.LAST_IP)).email(row.getString(this.col.EMAIL)).registrationDate(row.getLong(this.col.REGISTRATION_DATE)).registrationIp(row.getString(this.col.REGISTRATION_IP)).groupId(group).locWorld(row.getString(this.col.LASTLOC_WORLD)).locX(row.getDouble(this.col.LASTLOC_X)).locY(row.getDouble(this.col.LASTLOC_Y)).locZ(row.getDouble(this.col.LASTLOC_Z)).locYaw(row.getFloat(this.col.LASTLOC_YAW)).locPitch(row.getFloat(this.col.LASTLOC_PITCH)).build();
    }
}

