/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.datasource;

import ch.jalu.datasourcecolumns.data.DataSourceValue;
import fr.xephi.authme.data.auth.PlayerAuth;
import fr.xephi.authme.datasource.DataSourceType;
import fr.xephi.authme.initialization.Reloadable;
import fr.xephi.authme.security.crypts.HashedPassword;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public interface DataSource
extends Reloadable {
    default public boolean isCached() {
        return false;
    }

    public boolean isAuthAvailable(String var1);

    public HashedPassword getPassword(String var1);

    public PlayerAuth getAuth(String var1);

    public boolean saveAuth(PlayerAuth var1);

    public boolean updateSession(PlayerAuth var1);

    public boolean updatePassword(PlayerAuth var1);

    public boolean updatePassword(String var1, HashedPassword var2);

    public Set<String> getRecordsToPurge(long var1);

    public void purgeRecords(Collection<String> var1);

    public boolean removeAuth(String var1);

    public boolean updateQuitLoc(PlayerAuth var1);

    public List<String> getAllAuthsByIp(String var1);

    public int countAuthsByEmail(String var1);

    public boolean updateEmail(PlayerAuth var1);

    public void closeConnection();

    public DataSourceType getType();

    public boolean isLogged(String var1);

    public void setLogged(String var1);

    public void setUnlogged(String var1);

    public boolean hasSession(String var1);

    public void grantSession(String var1);

    public void revokeSession(String var1);

    public void purgeLogged();

    public List<String> getLoggedPlayersWithEmptyMail();

    public int getAccountsRegistered();

    public boolean updateRealName(String var1, String var2);

    public DataSourceValue<String> getEmail(String var1);

    public List<PlayerAuth> getAllAuths();

    public List<PlayerAuth> getRecentlyLoggedInPlayers();

    public boolean setTotpKey(String var1, String var2);

    default public boolean removeTotpKey(String user) {
        return this.setTotpKey(user, null);
    }

    @Override
    public void reload();

    default public void invalidateCache(String playerName) {
    }

    default public void refreshCache(String playerName) {
    }
}

