/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.datasource;

import ch.jalu.datasourcecolumns.data.DataSourceValue;
import ch.jalu.datasourcecolumns.data.DataSourceValueImpl;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.data.auth.PlayerAuth;
import fr.xephi.authme.data.auth.PlayerCache;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.datasource.DataSourceType;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.security.crypts.HashedPassword;
import fr.xephi.authme.util.Utils;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class CacheDataSource
implements DataSource {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(CacheDataSource.class);
    private final DataSource source;
    private final PlayerCache playerCache;
    private final LoadingCache<String, Optional<PlayerAuth>> cachedAuths;
    private final ListeningExecutorService executorService;

    public CacheDataSource(final DataSource source, PlayerCache playerCache) {
        this.source = source;
        this.playerCache = playerCache;
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("AuthMe-CacheLoader").build()));
        this.cachedAuths = CacheBuilder.newBuilder().refreshAfterWrite(5L, TimeUnit.MINUTES).expireAfterAccess(15L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Optional<PlayerAuth>>(){

            public Optional<PlayerAuth> load(String key) {
                return Optional.ofNullable(source.getAuth(key));
            }

            public ListenableFuture<Optional<PlayerAuth>> reload(String key, Optional<PlayerAuth> oldValue) {
                return CacheDataSource.this.executorService.submit(() -> this.load(key));
            }
        });
    }

    public LoadingCache<String, Optional<PlayerAuth>> getCachedAuths() {
        return this.cachedAuths;
    }

    @Override
    public void reload() {
        this.source.reload();
    }

    @Override
    public boolean isCached() {
        return true;
    }

    @Override
    public boolean isAuthAvailable(String user) {
        return this.getAuth(user) != null;
    }

    @Override
    public HashedPassword getPassword(String user) {
        Optional pAuthOpt = (Optional)this.cachedAuths.getIfPresent((Object)(user = user.toLowerCase(Locale.ROOT)));
        if (pAuthOpt != null && pAuthOpt.isPresent()) {
            return ((PlayerAuth)pAuthOpt.get()).getPassword();
        }
        return this.source.getPassword(user);
    }

    @Override
    public PlayerAuth getAuth(String user) {
        user = user.toLowerCase(Locale.ROOT);
        return ((Optional)this.cachedAuths.getUnchecked((Object)user)).orElse(null);
    }

    @Override
    public boolean saveAuth(PlayerAuth auth) {
        boolean result = this.source.saveAuth(auth);
        if (result) {
            this.cachedAuths.refresh((Object)auth.getNickname());
        }
        return result;
    }

    @Override
    public boolean updatePassword(PlayerAuth auth) {
        boolean result = this.source.updatePassword(auth);
        if (result) {
            this.cachedAuths.refresh((Object)auth.getNickname());
        }
        return result;
    }

    @Override
    public boolean updatePassword(String user, HashedPassword password) {
        boolean result = this.source.updatePassword(user = user.toLowerCase(Locale.ROOT), password);
        if (result) {
            this.cachedAuths.refresh((Object)user);
        }
        return result;
    }

    @Override
    public boolean updateSession(PlayerAuth auth) {
        boolean result = this.source.updateSession(auth);
        if (result) {
            this.cachedAuths.refresh((Object)auth.getNickname());
        }
        return result;
    }

    @Override
    public boolean updateQuitLoc(PlayerAuth auth) {
        boolean result = this.source.updateQuitLoc(auth);
        if (result) {
            this.cachedAuths.refresh((Object)auth.getNickname());
        }
        return result;
    }

    @Override
    public Set<String> getRecordsToPurge(long until) {
        return this.source.getRecordsToPurge(until);
    }

    @Override
    public boolean removeAuth(String name) {
        boolean result = this.source.removeAuth(name = name.toLowerCase(Locale.ROOT));
        if (result) {
            this.cachedAuths.invalidate((Object)name);
        }
        return result;
    }

    @Override
    public void closeConnection() {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.logException("Could not close executor service:", e);
        }
        this.cachedAuths.invalidateAll();
        this.source.closeConnection();
    }

    @Override
    public boolean updateEmail(PlayerAuth auth) {
        boolean result = this.source.updateEmail(auth);
        if (result) {
            this.cachedAuths.refresh((Object)auth.getNickname());
        }
        return result;
    }

    @Override
    public List<String> getAllAuthsByIp(String ip) {
        return this.source.getAllAuthsByIp(ip);
    }

    @Override
    public int countAuthsByEmail(String email) {
        return this.source.countAuthsByEmail(email);
    }

    @Override
    public void purgeRecords(Collection<String> banned) {
        this.source.purgeRecords(banned);
        this.cachedAuths.invalidateAll(banned);
    }

    @Override
    public DataSourceType getType() {
        return this.source.getType();
    }

    @Override
    public boolean isLogged(String user) {
        return this.source.isLogged(user);
    }

    @Override
    public void setLogged(String user) {
        this.source.setLogged(user.toLowerCase(Locale.ROOT));
    }

    @Override
    public void setUnlogged(String user) {
        this.source.setUnlogged(user.toLowerCase(Locale.ROOT));
    }

    @Override
    public boolean hasSession(String user) {
        return this.source.hasSession(user);
    }

    @Override
    public void grantSession(String user) {
        this.source.grantSession(user);
    }

    @Override
    public void revokeSession(String user) {
        this.source.revokeSession(user);
    }

    @Override
    public void purgeLogged() {
        this.source.purgeLogged();
        this.cachedAuths.invalidateAll();
    }

    @Override
    public int getAccountsRegistered() {
        return this.source.getAccountsRegistered();
    }

    @Override
    public boolean updateRealName(String user, String realName) {
        boolean result = this.source.updateRealName(user, realName);
        if (result) {
            this.cachedAuths.refresh((Object)user);
        }
        return result;
    }

    @Override
    public DataSourceValue<String> getEmail(String user) {
        return (DataSourceValue)((Optional)this.cachedAuths.getUnchecked((Object)user)).map(auth -> DataSourceValueImpl.of((Object)auth.getEmail())).orElse(DataSourceValueImpl.unknownRow());
    }

    @Override
    public List<PlayerAuth> getAllAuths() {
        return this.source.getAllAuths();
    }

    @Override
    public List<String> getLoggedPlayersWithEmptyMail() {
        return this.playerCache.getCache().values().stream().filter(auth -> Utils.isEmailEmpty(auth.getEmail())).map(PlayerAuth::getRealName).collect(Collectors.toList());
    }

    @Override
    public List<PlayerAuth> getRecentlyLoggedInPlayers() {
        return this.source.getRecentlyLoggedInPlayers();
    }

    @Override
    public boolean setTotpKey(String user, String totpKey) {
        boolean result = this.source.setTotpKey(user, totpKey);
        if (result) {
            this.cachedAuths.refresh((Object)user);
        }
        return result;
    }

    @Override
    public void invalidateCache(String playerName) {
        this.cachedAuths.invalidate((Object)playerName);
    }

    @Override
    public void refreshCache(String playerName) {
        if (this.cachedAuths.getIfPresent((Object)playerName) != null) {
            this.cachedAuths.refresh((Object)playerName);
        }
    }
}

