/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.datasource;

import ch.jalu.datasourcecolumns.data.DataSourceValue;
import ch.jalu.datasourcecolumns.data.DataSourceValueImpl;
import ch.jalu.datasourcecolumns.data.DataSourceValues;
import ch.jalu.datasourcecolumns.data.UpdateValues;
import ch.jalu.datasourcecolumns.predicate.AlwaysTruePredicate;
import ch.jalu.datasourcecolumns.predicate.Predicate;
import ch.jalu.datasourcecolumns.predicate.StandardPredicates;
import fr.xephi.authme.data.auth.PlayerAuth;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.datasource.SqlDataSourceUtils;
import fr.xephi.authme.datasource.columnshandler.AuthMeColumns;
import fr.xephi.authme.datasource.columnshandler.AuthMeColumnsHandler;
import fr.xephi.authme.datasource.columnshandler.ColumnContext;
import fr.xephi.authme.security.crypts.HashedPassword;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public abstract class AbstractSqlDataSource
implements DataSource {
    protected AuthMeColumnsHandler columnsHandler;

    @Override
    public boolean isAuthAvailable(String user) {
        try {
            return this.columnsHandler.retrieve(user, AuthMeColumns.NAME).rowExists();
        }
        catch (SQLException e) {
            SqlDataSourceUtils.logSqlException(e);
            return false;
        }
    }

    @Override
    public HashedPassword getPassword(String user) {
        try {
            DataSourceValues values = this.columnsHandler.retrieve(user, AuthMeColumns.PASSWORD, AuthMeColumns.SALT);
            if (values.rowExists()) {
                return new HashedPassword((String)values.get(AuthMeColumns.PASSWORD), (String)values.get(AuthMeColumns.SALT));
            }
        }
        catch (SQLException e) {
            SqlDataSourceUtils.logSqlException(e);
        }
        return null;
    }

    @Override
    public boolean saveAuth(PlayerAuth auth) {
        return this.columnsHandler.insert(auth, AuthMeColumns.NAME, AuthMeColumns.NICK_NAME, AuthMeColumns.PASSWORD, AuthMeColumns.SALT, AuthMeColumns.EMAIL, AuthMeColumns.REGISTRATION_DATE, AuthMeColumns.REGISTRATION_IP, AuthMeColumns.UUID);
    }

    @Override
    public boolean hasSession(String user) {
        try {
            DataSourceValue<Integer> result = this.columnsHandler.retrieve(user, AuthMeColumns.HAS_SESSION);
            return result.rowExists() && Integer.valueOf(1).equals(result.getValue());
        }
        catch (SQLException e) {
            SqlDataSourceUtils.logSqlException(e);
            return false;
        }
    }

    @Override
    public boolean updateSession(PlayerAuth auth) {
        return this.columnsHandler.update(auth, AuthMeColumns.LAST_IP, AuthMeColumns.LAST_LOGIN, AuthMeColumns.NICK_NAME);
    }

    @Override
    public boolean updatePassword(PlayerAuth auth) {
        return this.updatePassword(auth.getNickname(), auth.getPassword());
    }

    @Override
    public boolean updatePassword(String user, HashedPassword password) {
        return this.columnsHandler.update(user, (UpdateValues<ColumnContext>)UpdateValues.with(AuthMeColumns.PASSWORD, (Object)password.getHash()).and(AuthMeColumns.SALT, (Object)password.getSalt()).build());
    }

    @Override
    public boolean updateQuitLoc(PlayerAuth auth) {
        return this.columnsHandler.update(auth, AuthMeColumns.LOCATION_X, AuthMeColumns.LOCATION_Y, AuthMeColumns.LOCATION_Z, AuthMeColumns.LOCATION_WORLD, AuthMeColumns.LOCATION_YAW, AuthMeColumns.LOCATION_PITCH);
    }

    @Override
    public List<String> getAllAuthsByIp(String ip) {
        try {
            return this.columnsHandler.retrieve((Predicate<ColumnContext>)StandardPredicates.eq(AuthMeColumns.LAST_IP, (Object)ip), AuthMeColumns.NAME);
        }
        catch (SQLException e) {
            SqlDataSourceUtils.logSqlException(e);
            return Collections.emptyList();
        }
    }

    @Override
    public int countAuthsByEmail(String email) {
        return this.columnsHandler.count((Predicate<ColumnContext>)StandardPredicates.eqIgnoreCase(AuthMeColumns.EMAIL, (String)email));
    }

    @Override
    public boolean updateEmail(PlayerAuth auth) {
        return this.columnsHandler.update(auth, AuthMeColumns.EMAIL);
    }

    @Override
    public boolean isLogged(String user) {
        try {
            DataSourceValue<Integer> result = this.columnsHandler.retrieve(user, AuthMeColumns.IS_LOGGED);
            return result.rowExists() && Integer.valueOf(1).equals(result.getValue());
        }
        catch (SQLException e) {
            SqlDataSourceUtils.logSqlException(e);
            return false;
        }
    }

    @Override
    public void setLogged(String user) {
        this.columnsHandler.update(user, AuthMeColumns.IS_LOGGED, Integer.valueOf(1));
    }

    @Override
    public void setUnlogged(String user) {
        this.columnsHandler.update(user, AuthMeColumns.IS_LOGGED, Integer.valueOf(0));
    }

    @Override
    public void grantSession(String user) {
        this.columnsHandler.update(user, AuthMeColumns.HAS_SESSION, Integer.valueOf(1));
    }

    @Override
    public void revokeSession(String user) {
        this.columnsHandler.update(user, AuthMeColumns.HAS_SESSION, Integer.valueOf(0));
    }

    @Override
    public void purgeLogged() {
        this.columnsHandler.update((Predicate<ColumnContext>)StandardPredicates.eq(AuthMeColumns.IS_LOGGED, (Object)1), AuthMeColumns.IS_LOGGED, Integer.valueOf(0));
    }

    @Override
    public int getAccountsRegistered() {
        return this.columnsHandler.count((Predicate<ColumnContext>)new AlwaysTruePredicate());
    }

    @Override
    public boolean updateRealName(String user, String realName) {
        return this.columnsHandler.update(user, AuthMeColumns.NICK_NAME, realName);
    }

    @Override
    public DataSourceValue<String> getEmail(String user) {
        try {
            return this.columnsHandler.retrieve(user, AuthMeColumns.EMAIL);
        }
        catch (SQLException e) {
            SqlDataSourceUtils.logSqlException(e);
            return DataSourceValueImpl.unknownRow();
        }
    }

    abstract String getJdbcUrl(String var1, String var2, String var3);
}

