/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.data.limbo.persistence;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import fr.xephi.authme.data.limbo.LimboPlayer;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Location;

class LimboPlayerSerializer
implements JsonSerializer<LimboPlayer> {
    static final String LOCATION = "location";
    static final String LOC_WORLD = "world";
    static final String LOC_X = "x";
    static final String LOC_Y = "y";
    static final String LOC_Z = "z";
    static final String LOC_YAW = "yaw";
    static final String LOC_PITCH = "pitch";
    static final String GROUPS = "groups";
    static final String IS_OP = "operator";
    static final String CAN_FLY = "can-fly";
    static final String WALK_SPEED = "walk-speed";
    static final String FLY_SPEED = "fly-speed";
    private static final Gson GSON = new Gson();

    LimboPlayerSerializer() {
    }

    public JsonElement serialize(LimboPlayer limboPlayer, Type type, JsonSerializationContext context) {
        Location loc = limboPlayer.getLocation();
        JsonObject locationObject = new JsonObject();
        locationObject.addProperty(LOC_WORLD, loc.getWorld().getName());
        locationObject.addProperty(LOC_X, (Number)loc.getX());
        locationObject.addProperty(LOC_Y, (Number)loc.getY());
        locationObject.addProperty(LOC_Z, (Number)loc.getZ());
        locationObject.addProperty(LOC_YAW, (Number)Float.valueOf(loc.getYaw()));
        locationObject.addProperty(LOC_PITCH, (Number)Float.valueOf(loc.getPitch()));
        JsonObject obj = new JsonObject();
        obj.add(LOCATION, (JsonElement)locationObject);
        List<JsonObject> groups = limboPlayer.getGroups().stream().map(g -> {
            JsonObject jsonGroup = new JsonObject();
            jsonGroup.addProperty("groupName", g.getGroupName());
            if (g.getContextMap() != null) {
                jsonGroup.addProperty("contextMap", GSON.toJson(g.getContextMap()));
            }
            return jsonGroup;
        }).collect(Collectors.toList());
        JsonArray jsonGroups = new JsonArray();
        groups.forEach(arg_0 -> ((JsonArray)jsonGroups).add(arg_0));
        obj.add(GROUPS, (JsonElement)jsonGroups);
        obj.addProperty(IS_OP, Boolean.valueOf(limboPlayer.isOperator()));
        obj.addProperty(CAN_FLY, Boolean.valueOf(limboPlayer.isCanFly()));
        obj.addProperty(WALK_SPEED, (Number)Float.valueOf(limboPlayer.getWalkSpeed()));
        obj.addProperty(FLY_SPEED, (Number)Float.valueOf(limboPlayer.getFlySpeed()));
        return obj;
    }
}

