/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.data.limbo.persistence;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fr.xephi.authme.data.limbo.LimboPlayer;
import fr.xephi.authme.data.limbo.UserGroup;
import fr.xephi.authme.service.BukkitService;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.bukkit.Location;
import org.bukkit.World;

class LimboPlayerDeserializer
implements JsonDeserializer<LimboPlayer> {
    private static final String GROUP_LEGACY = "group";
    private static final String CONTEXT_MAP = "contextMap";
    private static final String GROUP_NAME = "groupName";
    private BukkitService bukkitService;

    LimboPlayerDeserializer(BukkitService bukkitService) {
        this.bukkitService = bukkitService;
    }

    public LimboPlayer deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (jsonObject == null) {
            return null;
        }
        Location loc = this.deserializeLocation(jsonObject);
        boolean operator = LimboPlayerDeserializer.getBoolean(jsonObject, "operator");
        List<UserGroup> groups = LimboPlayerDeserializer.getLimboGroups(jsonObject);
        boolean canFly = LimboPlayerDeserializer.getBoolean(jsonObject, "can-fly");
        float walkSpeed = LimboPlayerDeserializer.getFloat(jsonObject, "walk-speed", 0.2f);
        float flySpeed = LimboPlayerDeserializer.getFloat(jsonObject, "fly-speed", 0.1f);
        return new LimboPlayer(loc, operator, groups, canFly, walkSpeed, flySpeed);
    }

    private Location deserializeLocation(JsonObject jsonObject) {
        JsonObject locationObject;
        World world;
        JsonObject e = jsonObject.getAsJsonObject("location");
        if (e != null && (world = this.bukkitService.getWorld(LimboPlayerDeserializer.getString(locationObject = e.getAsJsonObject(), "world"))) != null) {
            double x = LimboPlayerDeserializer.getDouble(locationObject, "x");
            double y = LimboPlayerDeserializer.getDouble(locationObject, "y");
            double z = LimboPlayerDeserializer.getDouble(locationObject, "z");
            float yaw = LimboPlayerDeserializer.getFloat(locationObject, "yaw");
            float pitch = LimboPlayerDeserializer.getFloat(locationObject, "pitch");
            return new Location(world, x, y, z, yaw, pitch);
        }
        return null;
    }

    private static String getString(JsonObject jsonObject, String memberName) {
        JsonElement element = jsonObject.get(memberName);
        return element != null ? element.getAsString() : "";
    }

    private static List<UserGroup> getLimboGroups(JsonObject jsonObject) {
        JsonElement element = jsonObject.get("groups");
        if (element == null) {
            String legacyGroup = Optional.ofNullable(jsonObject.get(GROUP_LEGACY)).map(JsonElement::getAsString).orElse(null);
            return legacyGroup == null ? Collections.emptyList() : Collections.singletonList(new UserGroup(legacyGroup, null));
        }
        ArrayList<UserGroup> result = new ArrayList<UserGroup>();
        JsonArray jsonArray = element.getAsJsonArray();
        for (JsonElement arrayElement : jsonArray) {
            if (!arrayElement.isJsonObject()) {
                result.add(new UserGroup(arrayElement.getAsString(), null));
                continue;
            }
            JsonObject jsonGroup = arrayElement.getAsJsonObject();
            Map contextMap = null;
            if (jsonGroup.has(CONTEXT_MAP)) {
                JsonElement contextMapJson = jsonGroup.get(CONTEXT_MAP);
                Type type = new TypeToken<Map<String, String>>(){}.getType();
                contextMap = (Map)new Gson().fromJson(contextMapJson.getAsString(), type);
            }
            String groupName = jsonGroup.get(GROUP_NAME).getAsString();
            result.add(new UserGroup(groupName, contextMap));
        }
        return result;
    }

    private static boolean getBoolean(JsonObject jsonObject, String memberName) {
        JsonElement element = jsonObject.get(memberName);
        return element != null && element.getAsBoolean();
    }

    private static float getFloat(JsonObject jsonObject, String memberName) {
        return LimboPlayerDeserializer.getNumberFromElement(jsonObject.get(memberName), JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
    }

    private static float getFloat(JsonObject jsonObject, String memberName, float defaultValue) {
        return LimboPlayerDeserializer.getNumberFromElement(jsonObject.get(memberName), JsonElement::getAsFloat, Float.valueOf(defaultValue)).floatValue();
    }

    private static double getDouble(JsonObject jsonObject, String memberName) {
        return LimboPlayerDeserializer.getNumberFromElement(jsonObject.get(memberName), JsonElement::getAsDouble, 0.0);
    }

    private static <N extends Number> N getNumberFromElement(JsonElement jsonElement, Function<JsonElement, N> numberFunction, N defaultValue) {
        if (jsonElement != null) {
            try {
                return (N)((Number)numberFunction.apply(jsonElement));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

