/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.data.limbo.persistence;

import ch.jalu.injector.factory.Factory;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.data.limbo.LimboPlayer;
import fr.xephi.authme.data.limbo.persistence.LimboPersistenceHandler;
import fr.xephi.authme.data.limbo.persistence.LimboPersistenceType;
import fr.xephi.authme.initialization.SettingsDependent;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.LimboSettings;
import javax.inject.Inject;
import org.bukkit.entity.Player;

public class LimboPersistence
implements SettingsDependent {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(LimboPersistence.class);
    private final Factory<LimboPersistenceHandler> handlerFactory;
    private LimboPersistenceHandler handler;

    @Inject
    LimboPersistence(Settings settings, Factory<LimboPersistenceHandler> handlerFactory) {
        this.handlerFactory = handlerFactory;
        this.reload(settings);
    }

    public LimboPlayer getLimboPlayer(Player player) {
        try {
            return this.handler.getLimboPlayer(player);
        }
        catch (Exception e) {
            this.logger.logException("Could not get LimboPlayer for '" + player.getName() + "'", e);
            return null;
        }
    }

    public void saveLimboPlayer(Player player, LimboPlayer limbo) {
        try {
            this.handler.saveLimboPlayer(player, limbo);
        }
        catch (Exception e) {
            this.logger.logException("Could not save LimboPlayer for '" + player.getName() + "'", e);
        }
    }

    public void removeLimboPlayer(Player player) {
        try {
            this.handler.removeLimboPlayer(player);
        }
        catch (Exception e) {
            this.logger.logException("Could not remove LimboPlayer for '" + player.getName() + "'", e);
        }
    }

    @Override
    public void reload(Settings settings) {
        LimboPersistenceType persistenceType = (LimboPersistenceType)((Object)settings.getProperty(LimboSettings.LIMBO_PERSISTENCE_TYPE));
        if (this.handler != null && this.handler.getType() != persistenceType) {
            this.logger.info("Limbo persistence type has changed! Note that the data is not converted.");
        }
        this.handler = (LimboPersistenceHandler)this.handlerFactory.newInstance(persistenceType.getImplementationClass());
    }
}

