/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.data.limbo.persistence;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.data.limbo.LimboPlayer;
import fr.xephi.authme.data.limbo.persistence.LimboPersistenceHandler;
import fr.xephi.authme.data.limbo.persistence.LimboPersistenceType;
import fr.xephi.authme.data.limbo.persistence.LimboPlayerDeserializer;
import fr.xephi.authme.data.limbo.persistence.LimboPlayerSerializer;
import fr.xephi.authme.initialization.DataFolder;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.service.BukkitService;
import fr.xephi.authme.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.bukkit.entity.Player;

class IndividualFilesPersistenceHandler
implements LimboPersistenceHandler {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(IndividualFilesPersistenceHandler.class);
    private final Gson gson;
    private final File cacheDir;

    @Inject
    IndividualFilesPersistenceHandler(@DataFolder File dataFolder, BukkitService bukkitService) {
        this.cacheDir = new File(dataFolder, "playerdata");
        if (!(this.cacheDir.exists() || this.cacheDir.isDirectory() || this.cacheDir.mkdir())) {
            this.logger.warning("Failed to create playerdata directory '" + String.valueOf(this.cacheDir) + "'");
        }
        this.gson = new GsonBuilder().registerTypeAdapter(LimboPlayer.class, (Object)new LimboPlayerSerializer()).registerTypeAdapter(LimboPlayer.class, (Object)new LimboPlayerDeserializer(bukkitService)).setPrettyPrinting().create();
    }

    @Override
    public LimboPlayer getLimboPlayer(Player player) {
        String id = player.getUniqueId().toString();
        File file = new File(this.cacheDir, id + File.separator + "data.json");
        if (!file.exists()) {
            return null;
        }
        try {
            String str = Files.asCharSource((File)file, (Charset)StandardCharsets.UTF_8).read();
            return (LimboPlayer)this.gson.fromJson(str, LimboPlayer.class);
        }
        catch (IOException e) {
            this.logger.logException("Could not read player data on disk for '" + player.getName() + "'", e);
            return null;
        }
    }

    @Override
    public void saveLimboPlayer(Player player, LimboPlayer limboPlayer) {
        String id = player.getUniqueId().toString();
        try {
            File file = new File(this.cacheDir, id + File.separator + "data.json");
            Files.createParentDirs((File)file);
            Files.touch((File)file);
            Files.write((CharSequence)this.gson.toJson((Object)limboPlayer), (File)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.logger.logException("Failed to write " + player.getName() + " data:", e);
        }
    }

    @Override
    public void removeLimboPlayer(Player player) {
        String id = player.getUniqueId().toString();
        File file = new File(this.cacheDir, id);
        if (file.exists()) {
            FileUtils.purgeDirectory(file);
            FileUtils.delete(file);
        }
    }

    @Override
    public LimboPersistenceType getType() {
        return LimboPersistenceType.INDIVIDUAL_FILES;
    }
}

