/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.data.limbo.persistence;

import com.google.common.io.Files;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.data.limbo.LimboPlayer;
import fr.xephi.authme.data.limbo.persistence.LimboPersistenceHandler;
import fr.xephi.authme.data.limbo.persistence.LimboPersistenceType;
import fr.xephi.authme.data.limbo.persistence.LimboPlayerDeserializer;
import fr.xephi.authme.data.limbo.persistence.LimboPlayerSerializer;
import fr.xephi.authme.data.limbo.persistence.SegmentNameBuilder;
import fr.xephi.authme.data.limbo.persistence.SegmentSize;
import fr.xephi.authme.initialization.DataFolder;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.service.BukkitService;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.LimboSettings;
import fr.xephi.authme.util.FileUtils;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.bukkit.entity.Player;

class DistributedFilesPersistenceHandler
implements LimboPersistenceHandler {
    private static final Type LIMBO_MAP_TYPE = new TypeToken<Map<String, LimboPlayer>>(){}.getType();
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(DistributedFilesPersistenceHandler.class);
    private final File cacheFolder;
    private final Gson gson;
    private final SegmentNameBuilder segmentNameBuilder;

    @Inject
    DistributedFilesPersistenceHandler(@DataFolder File dataFolder, BukkitService bukkitService, Settings settings) {
        this.cacheFolder = new File(dataFolder, "playerdata");
        FileUtils.createDirectory(this.cacheFolder);
        this.gson = new GsonBuilder().registerTypeAdapter(LimboPlayer.class, (Object)new LimboPlayerSerializer()).registerTypeAdapter(LimboPlayer.class, (Object)new LimboPlayerDeserializer(bukkitService)).setPrettyPrinting().create();
        this.segmentNameBuilder = new SegmentNameBuilder((SegmentSize)((Object)settings.getProperty(LimboSettings.DISTRIBUTION_SIZE)));
        this.convertOldDataToCurrentSegmentScheme();
        this.deleteEmptyFiles();
    }

    @Override
    public LimboPlayer getLimboPlayer(Player player) {
        String uuid = player.getUniqueId().toString();
        File file = this.getPlayerSegmentFile(uuid);
        Map<String, LimboPlayer> entries = this.readLimboPlayers(file);
        return entries == null ? null : entries.get(uuid);
    }

    @Override
    public void saveLimboPlayer(Player player, LimboPlayer limbo) {
        String uuid = player.getUniqueId().toString();
        File file = this.getPlayerSegmentFile(uuid);
        Map<String, LimboPlayer> entries = null;
        if (file.exists()) {
            entries = this.readLimboPlayers(file);
        } else {
            FileUtils.create(file);
        }
        if (entries == null) {
            entries = new HashMap<String, LimboPlayer>();
        }
        entries.put(uuid, limbo);
        this.saveEntries(entries, file);
    }

    @Override
    public void removeLimboPlayer(Player player) {
        Map<String, LimboPlayer> entries;
        String uuid = player.getUniqueId().toString();
        File file = this.getPlayerSegmentFile(uuid);
        if (file.exists() && (entries = this.readLimboPlayers(file)) != null && entries.remove(uuid) != null) {
            this.saveEntries(entries, file);
        }
    }

    @Override
    public LimboPersistenceType getType() {
        return LimboPersistenceType.DISTRIBUTED_FILES;
    }

    private void saveEntries(Map<String, LimboPlayer> entries, File file) {
        try (FileWriter fw = new FileWriter(file);){
            this.gson.toJson(entries, (Appendable)fw);
        }
        catch (Exception e) {
            this.logger.logException("Could not write to '" + String.valueOf(file) + "':", e);
        }
    }

    private Map<String, LimboPlayer> readLimboPlayers(File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            return (Map)this.gson.fromJson(Files.asCharSource((File)file, (Charset)StandardCharsets.UTF_8).read(), LIMBO_MAP_TYPE);
        }
        catch (Exception e) {
            this.logger.logException("Failed reading '" + String.valueOf(file) + "':", e);
            return null;
        }
    }

    private File getPlayerSegmentFile(String uuid) {
        String segment = this.segmentNameBuilder.createSegmentName(uuid);
        return this.getSegmentFile(segment);
    }

    private File getSegmentFile(String segmentId) {
        return new File(this.cacheFolder, segmentId + "-limbo.json");
    }

    private void convertOldDataToCurrentSegmentScheme() {
        String currentPrefix = this.segmentNameBuilder.getPrefix();
        File[] files = this.listFiles(this.cacheFolder);
        HashMap<String, LimboPlayer> allLimboPlayers = new HashMap<String, LimboPlayer>();
        ArrayList<File> migratedFiles = new ArrayList<File>();
        for (File file : files) {
            Map<String, LimboPlayer> data;
            if (!DistributedFilesPersistenceHandler.isLimboJsonFile(file) || file.getName().startsWith(currentPrefix) || (data = this.readLimboPlayers(file)) == null) continue;
            allLimboPlayers.putAll(data);
            migratedFiles.add(file);
        }
        if (!allLimboPlayers.isEmpty()) {
            this.saveToNewSegments(allLimboPlayers);
            migratedFiles.forEach(FileUtils::delete);
        }
    }

    private void saveToNewSegments(Map<String, LimboPlayer> limbosFromOldSegments) {
        Map<String, Map<String, LimboPlayer>> limboBySegment = this.groupBySegment(limbosFromOldSegments);
        this.logger.info("Saving " + limbosFromOldSegments.size() + " LimboPlayers from old segments into " + limboBySegment.size() + " current segments");
        for (Map.Entry<String, Map<String, LimboPlayer>> entry : limboBySegment.entrySet()) {
            File file = this.getSegmentFile(entry.getKey());
            Map limbosToSave = Optional.ofNullable(this.readLimboPlayers(file)).orElseGet(HashMap::new);
            limbosToSave.putAll(entry.getValue());
            this.saveEntries(limbosToSave, file);
        }
    }

    private Map<String, Map<String, LimboPlayer>> groupBySegment(Map<String, LimboPlayer> readLimboPlayers) {
        HashMap<String, Map<String, LimboPlayer>> limboBySegment = new HashMap<String, Map<String, LimboPlayer>>();
        for (Map.Entry<String, LimboPlayer> entry : readLimboPlayers.entrySet()) {
            String segmentId = this.segmentNameBuilder.createSegmentName(entry.getKey());
            limboBySegment.computeIfAbsent(segmentId, s -> new HashMap()).put(entry.getKey(), entry.getValue());
        }
        return limboBySegment;
    }

    private void deleteEmptyFiles() {
        File[] files = this.listFiles(this.cacheFolder);
        long deletedFiles = Arrays.stream(files).filter(f -> DistributedFilesPersistenceHandler.isLimboJsonFile(f) && f.length() < 3L).peek(FileUtils::delete).count();
        this.logger.debug("Limbo: Deleted {0} empty segment files", (Object)deletedFiles);
    }

    private static boolean isLimboJsonFile(File file) {
        String name = file.getName();
        return name.startsWith("seg") && name.endsWith("-limbo.json");
    }

    private File[] listFiles(File folder) {
        File[] files = folder.listFiles();
        if (files == null) {
            this.logger.warning("Could not get files of '" + String.valueOf(folder) + "'");
            return new File[0];
        }
        return files;
    }
}

