/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.data.limbo;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.data.limbo.LimboPlayer;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import org.bukkit.entity.Player;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum WalkFlySpeedRestoreType {
    RESTORE{

        @Override
        public void restoreFlySpeed(Player player, LimboPlayer limbo) {
            logger.debug(() -> "Restoring fly speed for LimboPlayer " + player.getName() + " to " + limbo.getFlySpeed() + " (RESTORE mode)");
            player.setFlySpeed(limbo.getFlySpeed());
        }

        @Override
        public void restoreWalkSpeed(Player player, LimboPlayer limbo) {
            logger.debug(() -> "Restoring walk speed for LimboPlayer " + player.getName() + " to " + limbo.getWalkSpeed() + " (RESTORE mode)");
            player.setWalkSpeed(limbo.getWalkSpeed());
        }
    }
    ,
    RESTORE_NO_ZERO{

        @Override
        public void restoreFlySpeed(Player player, LimboPlayer limbo) {
            float limboFlySpeed = limbo.getFlySpeed();
            if (limboFlySpeed > 0.01f) {
                logger.debug(() -> "Restoring fly speed for LimboPlayer " + player.getName() + " to " + limboFlySpeed + " (RESTORE_NO_ZERO mode)");
                player.setFlySpeed(limboFlySpeed);
            } else {
                logger.debug(() -> "Restoring fly speed for LimboPlayer " + player.getName() + " to DEFAULT, it was 0! (RESTORE_NO_ZERO mode)");
                player.setFlySpeed(0.1f);
            }
        }

        @Override
        public void restoreWalkSpeed(Player player, LimboPlayer limbo) {
            float limboWalkSpeed = limbo.getWalkSpeed();
            if (limboWalkSpeed > 0.01f) {
                logger.debug(() -> "Restoring walk speed for LimboPlayer " + player.getName() + " to " + limboWalkSpeed + " (RESTORE_NO_ZERO mode)");
                player.setWalkSpeed(limboWalkSpeed);
            } else {
                logger.debug(() -> "Restoring walk speed for LimboPlayer " + player.getName() + " to DEFAULT, it was 0! (RESTORE_NO_ZERO mode)");
                player.setWalkSpeed(0.2f);
            }
        }
    }
    ,
    MAX_RESTORE{

        @Override
        public void restoreFlySpeed(Player player, LimboPlayer limbo) {
            float newSpeed = Math.max(player.getFlySpeed(), limbo.getFlySpeed());
            logger.debug(() -> "Restoring fly speed for LimboPlayer " + player.getName() + " to " + newSpeed + " (Current: " + player.getFlySpeed() + ", Limbo: " + limbo.getFlySpeed() + ") (MAX_RESTORE mode)");
            player.setFlySpeed(newSpeed);
        }

        @Override
        public void restoreWalkSpeed(Player player, LimboPlayer limbo) {
            float newSpeed = Math.max(player.getWalkSpeed(), limbo.getWalkSpeed());
            logger.debug(() -> "Restoring walk speed for LimboPlayer " + player.getName() + " to " + newSpeed + " (Current: " + player.getWalkSpeed() + ", Limbo: " + limbo.getWalkSpeed() + ") (MAX_RESTORE mode)");
            player.setWalkSpeed(newSpeed);
        }
    }
    ,
    DEFAULT{

        @Override
        public void restoreFlySpeed(Player player, LimboPlayer limbo) {
            logger.debug(() -> "Restoring fly speed for LimboPlayer " + player.getName() + " to DEFAULT (DEFAULT mode)");
            player.setFlySpeed(0.1f);
        }

        @Override
        public void restoreWalkSpeed(Player player, LimboPlayer limbo) {
            logger.debug(() -> "Restoring walk speed for LimboPlayer " + player.getName() + " to DEFAULT (DEFAULT mode)");
            player.setWalkSpeed(0.2f);
        }
    };

    private static final ConsoleLogger logger;

    public abstract void restoreFlySpeed(Player var1, LimboPlayer var2);

    public abstract void restoreWalkSpeed(Player var1, LimboPlayer var2);

    static {
        logger = ConsoleLoggerFactory.get(WalkFlySpeedRestoreType.class);
    }
}

