/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.data.limbo;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.data.limbo.AllowFlightRestoreType;
import fr.xephi.authme.data.limbo.LimboPlayer;
import fr.xephi.authme.data.limbo.UserGroup;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.permission.PermissionsManager;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.LimboSettings;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import fr.xephi.authme.util.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

class LimboServiceHelper {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(LimboServiceHelper.class);
    @Inject
    private PermissionsManager permissionsManager;
    @Inject
    private Settings settings;

    LimboServiceHelper() {
    }

    LimboPlayer createLimboPlayer(Player player, boolean isRegistered, Location location) {
        boolean isOperator = isRegistered && player.isOp();
        boolean flyEnabled = player.getAllowFlight();
        float walkSpeed = player.getWalkSpeed();
        float flySpeed = player.getFlySpeed();
        List<UserGroup> playerGroups = this.permissionsManager.hasGroupSupport() ? this.permissionsManager.getGroups((OfflinePlayer)player) : Collections.emptyList();
        List groupNames = playerGroups.stream().map(UserGroup::getGroupName).collect(Collectors.toList());
        this.logger.debug("Player `{0}` has groups `{1}`", (Object)player.getName(), (Object)String.join((CharSequence)", ", groupNames));
        return new LimboPlayer(location, isOperator, playerGroups, flyEnabled, walkSpeed, flySpeed);
    }

    void revokeLimboStates(Player player) {
        player.setOp(false);
        ((AllowFlightRestoreType)((Object)this.settings.getProperty(LimboSettings.RESTORE_ALLOW_FLIGHT))).processPlayer(player);
        if (!((Boolean)this.settings.getProperty(RestrictionSettings.ALLOW_UNAUTHED_MOVEMENT)).booleanValue()) {
            player.setFlySpeed(0.0f);
            player.setWalkSpeed(0.0f);
        }
    }

    LimboPlayer merge(LimboPlayer newLimbo, LimboPlayer oldLimbo) {
        if (newLimbo == null) {
            return oldLimbo;
        }
        if (oldLimbo == null) {
            return newLimbo;
        }
        boolean isOperator = newLimbo.isOperator() || oldLimbo.isOperator();
        boolean canFly = newLimbo.isCanFly() || oldLimbo.isCanFly();
        float flySpeed = Math.max(newLimbo.getFlySpeed(), oldLimbo.getFlySpeed());
        float walkSpeed = Math.max(newLimbo.getWalkSpeed(), oldLimbo.getWalkSpeed());
        Collection<UserGroup> groups = this.getLimboGroups(oldLimbo.getGroups(), newLimbo.getGroups());
        Location location = LimboServiceHelper.firstNotNull(oldLimbo.getLocation(), newLimbo.getLocation());
        return new LimboPlayer(location, isOperator, groups, canFly, walkSpeed, flySpeed);
    }

    private static Location firstNotNull(Location first, Location second) {
        return first == null ? second : first;
    }

    private Collection<UserGroup> getLimboGroups(Collection<UserGroup> oldLimboGroups, Collection<UserGroup> newLimboGroups) {
        this.logger.debug("Limbo merge: new and old groups are `{0}` and `{1}`", (Object)newLimboGroups, (Object)oldLimboGroups);
        return Utils.isCollectionEmpty(oldLimboGroups) ? newLimboGroups : oldLimboGroups;
    }
}

