/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.data.limbo;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.data.limbo.AllowFlightRestoreType;
import fr.xephi.authme.data.limbo.AuthGroupHandler;
import fr.xephi.authme.data.limbo.AuthGroupType;
import fr.xephi.authme.data.limbo.LimboMessageType;
import fr.xephi.authme.data.limbo.LimboPlayer;
import fr.xephi.authme.data.limbo.LimboPlayerTaskManager;
import fr.xephi.authme.data.limbo.LimboServiceHelper;
import fr.xephi.authme.data.limbo.WalkFlySpeedRestoreType;
import fr.xephi.authme.data.limbo.persistence.LimboPersistence;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.SpawnLoader;
import fr.xephi.authme.settings.properties.LimboSettings;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class LimboService {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(LimboService.class);
    private final Map<String, LimboPlayer> entries = new ConcurrentHashMap<String, LimboPlayer>();
    @Inject
    private Settings settings;
    @Inject
    private LimboPlayerTaskManager taskManager;
    @Inject
    private LimboServiceHelper helper;
    @Inject
    private LimboPersistence persistence;
    @Inject
    private AuthGroupHandler authGroupHandler;
    @Inject
    private SpawnLoader spawnLoader;

    LimboService() {
    }

    public void createLimboPlayer(Player player, boolean isRegistered) {
        LimboPlayer existingLimbo;
        String name = player.getName().toLowerCase(Locale.ROOT);
        LimboPlayer limboFromDisk = this.persistence.getLimboPlayer(player);
        if (limboFromDisk != null) {
            this.logger.debug("LimboPlayer for `{0}` already exists on disk", (Object)name);
        }
        if ((existingLimbo = this.entries.remove(name)) != null) {
            existingLimbo.clearTasks();
            this.logger.debug("LimboPlayer for `{0}` already present in memory", (Object)name);
        }
        Location location = this.spawnLoader.getPlayerLocationOrSpawn(player);
        LimboPlayer limboPlayer = this.helper.merge(existingLimbo, limboFromDisk);
        limboPlayer = this.helper.merge(this.helper.createLimboPlayer(player, isRegistered, location), limboPlayer);
        this.taskManager.registerMessageTask(player, limboPlayer, isRegistered ? LimboMessageType.LOG_IN : LimboMessageType.REGISTER);
        this.taskManager.registerTimeoutTask(player, limboPlayer);
        this.helper.revokeLimboStates(player);
        this.authGroupHandler.setGroup(player, limboPlayer, isRegistered ? AuthGroupType.REGISTERED_UNAUTHENTICATED : AuthGroupType.UNREGISTERED);
        this.entries.put(name, limboPlayer);
        this.persistence.saveLimboPlayer(player, limboPlayer);
    }

    public LimboPlayer getLimboPlayer(String name) {
        return this.entries.get(name.toLowerCase(Locale.ROOT));
    }

    public boolean hasLimboPlayer(String name) {
        return this.entries.containsKey(name.toLowerCase(Locale.ROOT));
    }

    public void restoreData(Player player) {
        String lowerName = player.getName().toLowerCase(Locale.ROOT);
        LimboPlayer limbo = this.entries.remove(lowerName);
        if (limbo == null) {
            this.logger.debug("No LimboPlayer found for `{0}` - cannot restore", (Object)lowerName);
        } else {
            player.setOp(limbo.isOperator());
            ((AllowFlightRestoreType)((Object)this.settings.getProperty(LimboSettings.RESTORE_ALLOW_FLIGHT))).restoreAllowFlight(player, limbo);
            ((WalkFlySpeedRestoreType)((Object)this.settings.getProperty(LimboSettings.RESTORE_FLY_SPEED))).restoreFlySpeed(player, limbo);
            ((WalkFlySpeedRestoreType)((Object)this.settings.getProperty(LimboSettings.RESTORE_WALK_SPEED))).restoreWalkSpeed(player, limbo);
            limbo.clearTasks();
            this.logger.debug("Restored LimboPlayer stats for `{0}`", (Object)lowerName);
            this.persistence.removeLimboPlayer(player);
        }
        this.authGroupHandler.setGroup(player, limbo, AuthGroupType.LOGGED_IN);
    }

    public void replaceTasksAfterRegistration(Player player) {
        Optional<LimboPlayer> limboPlayer = this.getLimboOrLogError(player, "reset tasks");
        limboPlayer.ifPresent(limbo -> {
            this.taskManager.registerTimeoutTask(player, (LimboPlayer)limbo);
            this.taskManager.registerMessageTask(player, (LimboPlayer)limbo, LimboMessageType.LOG_IN);
        });
        this.authGroupHandler.setGroup(player, limboPlayer.orElse(null), AuthGroupType.REGISTERED_UNAUTHENTICATED);
    }

    public void resetMessageTask(Player player, LimboMessageType messageType) {
        this.getLimboOrLogError(player, "reset message task").ifPresent(limbo -> this.taskManager.registerMessageTask(player, (LimboPlayer)limbo, messageType));
    }

    public void muteMessageTask(Player player) {
        this.getLimboOrLogError(player, "mute message task").ifPresent(limbo -> LimboPlayerTaskManager.setMuted(limbo.getMessageTask(), true));
    }

    public void unmuteMessageTask(Player player) {
        this.getLimboOrLogError(player, "unmute message task").ifPresent(limbo -> LimboPlayerTaskManager.setMuted(limbo.getMessageTask(), false));
    }

    private Optional<LimboPlayer> getLimboOrLogError(Player player, String context) {
        LimboPlayer limbo = this.entries.get(player.getName().toLowerCase(Locale.ROOT));
        if (limbo == null) {
            this.logger.debug("No LimboPlayer found for `{0}`. Action: {1}", (Object)player.getName(), (Object)context);
        }
        return Optional.ofNullable(limbo);
    }
}

