/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.data.limbo;

import fr.xephi.authme.data.auth.PlayerCache;
import fr.xephi.authme.data.captcha.RegistrationCaptchaManager;
import fr.xephi.authme.data.limbo.LimboMessageType;
import fr.xephi.authme.data.limbo.LimboPlayer;
import fr.xephi.authme.message.MessageKey;
import fr.xephi.authme.message.Messages;
import fr.xephi.authme.service.BukkitService;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.RegistrationSettings;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import fr.xephi.authme.task.MessageTask;
import fr.xephi.authme.task.TimeoutTask;
import javax.inject.Inject;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitTask;

class LimboPlayerTaskManager {
    @Inject
    private Messages messages;
    @Inject
    private Settings settings;
    @Inject
    private BukkitService bukkitService;
    @Inject
    private PlayerCache playerCache;
    @Inject
    private RegistrationCaptchaManager registrationCaptchaManager;

    LimboPlayerTaskManager() {
    }

    void registerMessageTask(Player player, LimboPlayer limbo, LimboMessageType messageType) {
        int interval = (Integer)this.settings.getProperty(RegistrationSettings.MESSAGE_INTERVAL);
        MessageResult result = this.getMessageKey(player.getName(), messageType);
        if (interval > 0) {
            String[] joinMessage = this.messages.retrieveSingle((CommandSender)player, result.messageKey, result.args).split("\n");
            MessageTask messageTask = new MessageTask(player, joinMessage);
            this.bukkitService.runTaskTimer(messageTask, 40L, interval * 20);
            limbo.setMessageTask(messageTask);
        }
    }

    void registerTimeoutTask(Player player, LimboPlayer limbo) {
        int timeout = (Integer)this.settings.getProperty(RestrictionSettings.TIMEOUT) * 20;
        if (timeout > 0) {
            String message = this.messages.retrieveSingle((CommandSender)player, MessageKey.LOGIN_TIMEOUT_ERROR, new String[0]);
            BukkitTask task = this.bukkitService.runTaskLater(new TimeoutTask(player, message, this.playerCache), timeout);
            limbo.setTimeoutTask(task);
        }
    }

    static void setMuted(MessageTask task, boolean isMuted) {
        if (task != null) {
            task.setMuted(isMuted);
        }
    }

    private MessageResult getMessageKey(String name, LimboMessageType messageType) {
        if (messageType == LimboMessageType.LOG_IN) {
            return new MessageResult(MessageKey.LOGIN_MESSAGE, new String[0]);
        }
        if (messageType == LimboMessageType.TOTP_CODE) {
            return new MessageResult(MessageKey.TWO_FACTOR_CODE_REQUIRED, new String[0]);
        }
        if (this.registrationCaptchaManager.isCaptchaRequired(name)) {
            String captchaCode = this.registrationCaptchaManager.getCaptchaCodeOrGenerateNew(name);
            return new MessageResult(MessageKey.CAPTCHA_FOR_REGISTRATION_REQUIRED, captchaCode);
        }
        return new MessageResult(MessageKey.REGISTER_MESSAGE, new String[0]);
    }

    private static final class MessageResult {
        private final MessageKey messageKey;
        private final String[] args;

        MessageResult(MessageKey messageKey, String ... args) {
            this.messageKey = messageKey;
            this.args = args;
        }
    }
}

