/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.data.limbo;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.data.limbo.AuthGroupType;
import fr.xephi.authme.data.limbo.LimboPlayer;
import fr.xephi.authme.data.limbo.UserGroup;
import fr.xephi.authme.initialization.Reloadable;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.permission.PermissionsManager;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.PluginSettings;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

class AuthGroupHandler
implements Reloadable {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(AuthGroupHandler.class);
    @Inject
    private PermissionsManager permissionsManager;
    @Inject
    private Settings settings;
    private UserGroup unregisteredGroup;
    private UserGroup registeredGroup;

    AuthGroupHandler() {
    }

    void setGroup(Player player, LimboPlayer limbo, AuthGroupType groupType) {
        if (!this.useAuthGroups()) {
            return;
        }
        List<UserGroup> previousGroups = limbo == null ? Collections.emptyList() : limbo.getGroups();
        switch (groupType) {
            case UNREGISTERED: {
                this.permissionsManager.addGroup((OfflinePlayer)player, this.unregisteredGroup);
                this.permissionsManager.removeGroup((OfflinePlayer)player, this.registeredGroup);
                this.permissionsManager.removeGroups((OfflinePlayer)player, previousGroups);
                break;
            }
            case REGISTERED_UNAUTHENTICATED: {
                this.permissionsManager.addGroup((OfflinePlayer)player, this.registeredGroup);
                this.permissionsManager.removeGroup((OfflinePlayer)player, this.unregisteredGroup);
                this.permissionsManager.removeGroups((OfflinePlayer)player, previousGroups);
                break;
            }
            case LOGGED_IN: {
                this.permissionsManager.addGroups((OfflinePlayer)player, previousGroups);
                this.permissionsManager.removeGroup((OfflinePlayer)player, this.unregisteredGroup);
                this.permissionsManager.removeGroup((OfflinePlayer)player, this.registeredGroup);
                break;
            }
            default: {
                throw new IllegalStateException("Encountered unhandled auth group type '" + String.valueOf((Object)groupType) + "'");
            }
        }
        this.logger.debug(() -> player.getName() + " changed to " + String.valueOf((Object)groupType) + ": has groups " + String.valueOf(this.permissionsManager.getGroups((OfflinePlayer)player)));
    }

    private boolean useAuthGroups() {
        if (!((Boolean)this.settings.getProperty(PluginSettings.ENABLE_PERMISSION_CHECK)).booleanValue()) {
            return false;
        }
        if (!this.permissionsManager.hasGroupSupport()) {
            this.logger.warning("The current permissions system doesn't have group support, unable to set group!");
            return false;
        }
        return true;
    }

    @Override
    @PostConstruct
    public void reload() {
        this.unregisteredGroup = new UserGroup((String)this.settings.getProperty(PluginSettings.UNREGISTERED_GROUP));
        this.registeredGroup = new UserGroup((String)this.settings.getProperty(PluginSettings.REGISTERED_GROUP));
    }
}

