/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.data;

import fr.xephi.authme.initialization.HasCleanup;
import fr.xephi.authme.initialization.SettingsDependent;
import fr.xephi.authme.message.MessageKey;
import fr.xephi.authme.message.Messages;
import fr.xephi.authme.service.BukkitService;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.SecuritySettings;
import fr.xephi.authme.util.PlayerUtils;
import fr.xephi.authme.util.expiring.TimedCounter;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TempbanManager
implements SettingsDependent,
HasCleanup {
    private final Map<String, TimedCounter<String>> ipLoginFailureCounts = new ConcurrentHashMap<String, TimedCounter<String>>();
    private final BukkitService bukkitService;
    private final Messages messages;
    private boolean isEnabled;
    private int threshold;
    private int length;
    private long resetThreshold;
    private String customCommand;

    @Inject
    TempbanManager(BukkitService bukkitService, Messages messages, Settings settings) {
        this.bukkitService = bukkitService;
        this.messages = messages;
        this.reload(settings);
    }

    public void increaseCount(String address, String name) {
        if (this.isEnabled) {
            TimedCounter countsByName = this.ipLoginFailureCounts.computeIfAbsent(address, k -> new TimedCounter(this.resetThreshold, TimeUnit.MINUTES));
            countsByName.increment(name);
        }
    }

    public void resetCount(String address, String name) {
        TimedCounter<String> counter;
        if (this.isEnabled && (counter = this.ipLoginFailureCounts.get(address)) != null) {
            counter.remove(name);
        }
    }

    public boolean shouldTempban(String address) {
        TimedCounter<String> countsByName;
        if (this.isEnabled && (countsByName = this.ipLoginFailureCounts.get(address)) != null) {
            return countsByName.total() >= this.threshold;
        }
        return false;
    }

    public void tempbanPlayer(Player player) {
        if (this.isEnabled) {
            String name = player.getName();
            String ip = PlayerUtils.getPlayerIp(player);
            String reason = this.messages.retrieveSingle((CommandSender)player, MessageKey.TEMPBAN_MAX_LOGINS, new String[0]);
            Date expires = new Date();
            long newTime = expires.getTime() + (long)this.length * 60000L;
            expires.setTime(newTime);
            this.bukkitService.scheduleSyncDelayedTask(() -> {
                if (this.customCommand.isEmpty()) {
                    this.bukkitService.banIp(ip, reason, expires, "AuthMe");
                    player.kickPlayer(reason);
                } else {
                    String command = this.customCommand.replace("%player%", name).replace("%ip%", ip);
                    this.bukkitService.dispatchConsoleCommand(command);
                }
            });
            this.ipLoginFailureCounts.remove(ip);
        }
    }

    @Override
    public void reload(Settings settings) {
        this.isEnabled = (Boolean)settings.getProperty(SecuritySettings.TEMPBAN_ON_MAX_LOGINS);
        this.threshold = (Integer)settings.getProperty(SecuritySettings.MAX_LOGIN_TEMPBAN);
        this.length = (Integer)settings.getProperty(SecuritySettings.TEMPBAN_LENGTH);
        this.resetThreshold = ((Integer)settings.getProperty(SecuritySettings.TEMPBAN_MINUTES_BEFORE_RESET)).intValue();
        this.customCommand = (String)settings.getProperty(SecuritySettings.TEMPBAN_CUSTOM_COMMAND);
    }

    @Override
    public void performCleanup() {
        for (TimedCounter<String> countsByIp : this.ipLoginFailureCounts.values()) {
            countsByIp.removeExpiredEntries();
        }
        this.ipLoginFailureCounts.entrySet().removeIf(e -> ((TimedCounter)e.getValue()).isEmpty());
    }
}

