/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.help;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import fr.xephi.authme.command.CommandArgumentDescription;
import fr.xephi.authme.command.CommandDescription;
import fr.xephi.authme.command.CommandUtils;
import fr.xephi.authme.command.FoundCommandResult;
import fr.xephi.authme.command.help.HelpMessage;
import fr.xephi.authme.command.help.HelpMessagesService;
import fr.xephi.authme.command.help.HelpSection;
import fr.xephi.authme.initialization.Reloadable;
import fr.xephi.authme.permission.DefaultPermission;
import fr.xephi.authme.permission.PermissionNode;
import fr.xephi.authme.permission.PermissionsManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.ServerOperator;

public class HelpProvider
implements Reloadable {
    public static final int SHOW_COMMAND = 1;
    public static final int SHOW_DESCRIPTION = 2;
    public static final int SHOW_LONG_DESCRIPTION = 4;
    public static final int SHOW_ARGUMENTS = 8;
    public static final int SHOW_PERMISSIONS = 16;
    public static final int SHOW_ALTERNATIVES = 32;
    public static final int SHOW_CHILDREN = 64;
    public static final int ALL_OPTIONS = -1;
    private final PermissionsManager permissionsManager;
    private final HelpMessagesService helpMessagesService;
    private Integer enabledSections;

    @Inject
    HelpProvider(PermissionsManager permissionsManager, HelpMessagesService helpMessagesService) {
        this.permissionsManager = permissionsManager;
        this.helpMessagesService = helpMessagesService;
    }

    private List<String> buildHelpOutput(CommandSender sender, FoundCommandResult result, int options) {
        if (result.getCommandDescription() == null) {
            return Collections.singletonList(String.valueOf(ChatColor.DARK_RED) + "Failed to retrieve any help information!");
        }
        ArrayList<String> lines = new ArrayList<String>();
        if ((options = this.filterDisabledSections(options)) == 0) {
            return lines;
        }
        String header = this.helpMessagesService.getMessage(HelpMessage.HEADER);
        if (!header.isEmpty()) {
            lines.add(String.valueOf(ChatColor.GOLD) + header);
        }
        CommandDescription command = this.helpMessagesService.buildLocalizedDescription(result.getCommandDescription());
        ImmutableList correctLabels = ImmutableList.copyOf(HelpProvider.filterCorrectLabels(command, result.getLabels()));
        if (HelpProvider.hasFlag(1, options)) {
            lines.add(String.valueOf(ChatColor.GOLD) + this.helpMessagesService.getMessage(HelpSection.COMMAND) + ": " + CommandUtils.buildSyntax(command, (List<String>)correctLabels));
        }
        if (HelpProvider.hasFlag(2, options)) {
            lines.add(String.valueOf(ChatColor.GOLD) + this.helpMessagesService.getMessage(HelpSection.SHORT_DESCRIPTION) + ": " + String.valueOf(ChatColor.WHITE) + command.getDescription());
        }
        if (HelpProvider.hasFlag(4, options)) {
            lines.add(String.valueOf(ChatColor.GOLD) + this.helpMessagesService.getMessage(HelpSection.DETAILED_DESCRIPTION) + ":");
            lines.add(String.valueOf(ChatColor.WHITE) + " " + command.getDetailedDescription());
        }
        if (HelpProvider.hasFlag(8, options)) {
            this.addArgumentsInfo(command, lines);
        }
        if (HelpProvider.hasFlag(16, options) && sender != null) {
            this.addPermissionsInfo(command, sender, lines);
        }
        if (HelpProvider.hasFlag(32, options)) {
            this.addAlternativesInfo(command, (List<String>)correctLabels, lines);
        }
        if (HelpProvider.hasFlag(64, options)) {
            this.addChildrenInfo(command, (List<String>)correctLabels, lines);
        }
        return lines;
    }

    public void outputHelp(CommandSender sender, FoundCommandResult result, int options) {
        List<String> lines = this.buildHelpOutput(sender, result, options);
        for (String line : lines) {
            sender.sendMessage(line);
        }
    }

    @Override
    public void reload() {
        this.enabledSections = null;
    }

    private int filterDisabledSections(int options) {
        if (this.enabledSections == null) {
            this.enabledSections = this.flagFor(HelpSection.COMMAND, 1) | this.flagFor(HelpSection.SHORT_DESCRIPTION, 2) | this.flagFor(HelpSection.DETAILED_DESCRIPTION, 4) | this.flagFor(HelpSection.ARGUMENTS, 8) | this.flagFor(HelpSection.PERMISSIONS, 16) | this.flagFor(HelpSection.ALTERNATIVES, 32) | this.flagFor(HelpSection.CHILDREN, 64);
        }
        return options & this.enabledSections;
    }

    private int flagFor(HelpSection section, int flag) {
        return this.helpMessagesService.getMessage(section).isEmpty() ? 0 : flag;
    }

    private void addArgumentsInfo(CommandDescription command, List<String> lines) {
        if (command.getArguments().isEmpty()) {
            return;
        }
        lines.add(String.valueOf(ChatColor.GOLD) + this.helpMessagesService.getMessage(HelpSection.ARGUMENTS) + ":");
        StringBuilder argString = new StringBuilder();
        String optionalText = " (" + this.helpMessagesService.getMessage(HelpMessage.OPTIONAL) + ")";
        for (CommandArgumentDescription argument : command.getArguments()) {
            argString.setLength(0);
            argString.append(" ").append(ChatColor.YELLOW).append(ChatColor.ITALIC).append(argument.getName()).append(": ").append(ChatColor.WHITE).append(argument.getDescription());
            if (argument.isOptional()) {
                argString.append(ChatColor.GRAY).append(ChatColor.ITALIC).append(optionalText);
            }
            lines.add(argString.toString());
        }
    }

    private void addAlternativesInfo(CommandDescription command, List<String> correctLabels, List<String> lines) {
        Function<String, List> commandLabelsFn;
        String usedLabel;
        if (command.getLabels().size() <= 1) {
            return;
        }
        lines.add(String.valueOf(ChatColor.GOLD) + this.helpMessagesService.getMessage(HelpSection.ALTERNATIVES) + ":");
        if (correctLabels.size() == 1) {
            usedLabel = correctLabels.get(0);
            commandLabelsFn = label -> Collections.singletonList(label);
        } else {
            usedLabel = correctLabels.get(1);
            commandLabelsFn = label -> Arrays.asList((String)correctLabels.get(0), label);
        }
        for (String label2 : command.getLabels()) {
            if (label2.equalsIgnoreCase(usedLabel)) continue;
            lines.add(" " + CommandUtils.buildSyntax(command, commandLabelsFn.apply(label2)));
        }
    }

    private void addPermissionsInfo(CommandDescription command, CommandSender sender, List<String> lines) {
        String permissionText;
        ChatColor permissionColor;
        PermissionNode permission = command.getPermission();
        if (permission == null) {
            return;
        }
        lines.add(String.valueOf(ChatColor.GOLD) + this.helpMessagesService.getMessage(HelpSection.PERMISSIONS) + ":");
        boolean hasPermission = this.permissionsManager.hasPermission(sender, permission);
        lines.add(String.format(" " + String.valueOf(ChatColor.YELLOW) + String.valueOf(ChatColor.ITALIC) + "%s" + String.valueOf(ChatColor.GRAY) + " (%s)", permission.getNode(), this.getLocalPermissionText(hasPermission)));
        DefaultPermission defaultPermission = permission.getDefaultPermission();
        Object addendum = "";
        if (DefaultPermission.OP_ONLY.equals((Object)defaultPermission)) {
            addendum = " (" + this.getLocalPermissionText(defaultPermission.evaluate((ServerOperator)sender)) + ")";
        }
        lines.add(String.valueOf(ChatColor.GOLD) + this.helpMessagesService.getMessage(HelpMessage.DEFAULT) + ": " + String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.ITALIC) + this.helpMessagesService.getMessage(defaultPermission) + (String)addendum);
        if (this.permissionsManager.hasPermission(sender, command.getPermission())) {
            permissionColor = ChatColor.GREEN;
            permissionText = this.getLocalPermissionText(true);
        } else {
            permissionColor = ChatColor.DARK_RED;
            permissionText = this.getLocalPermissionText(false);
        }
        lines.add(String.format(String.valueOf(ChatColor.GOLD) + " %s: %s" + String.valueOf(ChatColor.ITALIC) + "%s", this.helpMessagesService.getMessage(HelpMessage.RESULT), permissionColor, permissionText));
    }

    private String getLocalPermissionText(boolean hasPermission) {
        if (hasPermission) {
            return this.helpMessagesService.getMessage(HelpMessage.HAS_PERMISSION);
        }
        return this.helpMessagesService.getMessage(HelpMessage.NO_PERMISSION);
    }

    private void addChildrenInfo(CommandDescription command, List<String> correctLabels, List<String> lines) {
        if (command.getChildren().isEmpty()) {
            return;
        }
        lines.add(String.valueOf(ChatColor.GOLD) + this.helpMessagesService.getMessage(HelpSection.CHILDREN) + ":");
        String parentCommandPath = String.join((CharSequence)" ", correctLabels);
        for (CommandDescription child : command.getChildren()) {
            lines.add(" /" + parentCommandPath + " " + child.getLabels().get(0) + String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.ITALIC) + ": " + this.helpMessagesService.getDescription(child));
        }
    }

    private static boolean hasFlag(int flag, int options) {
        return (flag & options) != 0;
    }

    @VisibleForTesting
    static List<String> filterCorrectLabels(CommandDescription command, List<String> labels) {
        List<CommandDescription> commands = CommandUtils.constructParentList(command);
        ArrayList<String> correctLabels = new ArrayList<String>();
        boolean foundIncorrectLabel = false;
        for (int i = 0; i < commands.size(); ++i) {
            if (!foundIncorrectLabel && i < labels.size() && commands.get(i).hasLabel(labels.get(i))) {
                correctLabels.add(labels.get(i));
                continue;
            }
            foundIncorrectLabel = true;
            correctLabels.add(commands.get(i).getLabels().get(0));
        }
        return correctLabels;
    }
}

