/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.help;

import com.google.common.base.CaseFormat;
import fr.xephi.authme.command.CommandArgumentDescription;
import fr.xephi.authme.command.CommandDescription;
import fr.xephi.authme.command.CommandUtils;
import fr.xephi.authme.command.help.HelpMessage;
import fr.xephi.authme.command.help.HelpSection;
import fr.xephi.authme.message.HelpMessagesFileHandler;
import fr.xephi.authme.permission.DefaultPermission;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class HelpMessagesService {
    private static final String COMMAND_PREFIX = "commands.";
    private static final String DESCRIPTION_SUFFIX = ".description";
    private static final String DETAILED_DESCRIPTION_SUFFIX = ".detailedDescription";
    private static final String DEFAULT_PERMISSIONS_PATH = "common.defaultPermissions.";
    private final HelpMessagesFileHandler helpMessagesFileHandler;

    @Inject
    HelpMessagesService(HelpMessagesFileHandler helpMessagesFileHandler) {
        this.helpMessagesFileHandler = helpMessagesFileHandler;
    }

    public CommandDescription buildLocalizedDescription(CommandDescription command) {
        String path = COMMAND_PREFIX + HelpMessagesService.getCommandSubPath(command);
        if (!this.helpMessagesFileHandler.hasSection(path)) {
            return command;
        }
        CommandDescription.CommandBuilder builder = CommandDescription.builder().description(this.getText(path + DESCRIPTION_SUFFIX, command::getDescription)).detailedDescription(this.getText(path + DETAILED_DESCRIPTION_SUFFIX, command::getDetailedDescription)).executableCommand(command.getExecutableCommand()).parent(command.getParent()).labels(command.getLabels()).permission(command.getPermission());
        int i = 1;
        for (CommandArgumentDescription argument : command.getArguments()) {
            String argPath = path + ".arg" + i;
            String label = this.getText(argPath + ".label", argument::getName);
            String description = this.getText(argPath + DESCRIPTION_SUFFIX, argument::getDescription);
            builder.withArgument(label, description, argument.isOptional());
            ++i;
        }
        CommandDescription localCommand = builder.build();
        localCommand.getChildren().addAll(command.getChildren());
        return localCommand;
    }

    public String getDescription(CommandDescription command) {
        return this.getText(COMMAND_PREFIX + HelpMessagesService.getCommandSubPath(command) + DESCRIPTION_SUFFIX, command::getDescription);
    }

    public String getMessage(HelpMessage message) {
        return this.helpMessagesFileHandler.getMessage(message.getKey());
    }

    public String getMessage(HelpSection section) {
        return this.helpMessagesFileHandler.getMessage(section.getKey());
    }

    public String getMessage(DefaultPermission defaultPermission) {
        String path = DEFAULT_PERMISSIONS_PATH + HelpMessagesService.getDefaultPermissionsSubPath(defaultPermission);
        return this.helpMessagesFileHandler.getMessage(path);
    }

    public static String getDefaultPermissionsSubPath(DefaultPermission defaultPermission) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, defaultPermission.name());
    }

    private String getText(String path, Supplier<String> defaultTextGetter) {
        String message = this.helpMessagesFileHandler.getMessageIfExists(path);
        return message == null ? defaultTextGetter.get() : message;
    }

    public void reloadMessagesFile() {
        this.helpMessagesFileHandler.reload();
    }

    public static String getCommandSubPath(CommandDescription command) {
        return CommandUtils.constructParentList(command).stream().map(cmd -> cmd.getLabels().get(0)).collect(Collectors.joining("."));
    }
}

