/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.register;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.command.PlayerCommand;
import fr.xephi.authme.data.captcha.RegistrationCaptchaManager;
import fr.xephi.authme.mail.EmailService;
import fr.xephi.authme.message.MessageKey;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.process.Management;
import fr.xephi.authme.process.register.RegisterSecondaryArgument;
import fr.xephi.authme.process.register.RegistrationType;
import fr.xephi.authme.process.register.executors.EmailRegisterParams;
import fr.xephi.authme.process.register.executors.PasswordRegisterParams;
import fr.xephi.authme.process.register.executors.RegistrationMethod;
import fr.xephi.authme.process.register.executors.TwoFactorRegisterParams;
import fr.xephi.authme.security.HashAlgorithm;
import fr.xephi.authme.service.CommonService;
import fr.xephi.authme.service.ValidationService;
import fr.xephi.authme.settings.properties.EmailSettings;
import fr.xephi.authme.settings.properties.RegistrationSettings;
import fr.xephi.authme.settings.properties.SecuritySettings;
import java.util.List;
import javax.inject.Inject;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RegisterCommand
extends PlayerCommand {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(RegisterCommand.class);
    @Inject
    private Management management;
    @Inject
    private CommonService commonService;
    @Inject
    private EmailService emailService;
    @Inject
    private ValidationService validationService;
    @Inject
    private RegistrationCaptchaManager registrationCaptchaManager;

    @Override
    public void runCommand(Player player, List<String> arguments) {
        if (!this.isCaptchaFulfilled(player)) {
            return;
        }
        if (this.commonService.getProperty(SecuritySettings.PASSWORD_HASH) == HashAlgorithm.TWO_FACTOR) {
            this.management.performRegister(RegistrationMethod.TWO_FACTOR_REGISTRATION, TwoFactorRegisterParams.of(player));
            return;
        }
        if (arguments.size() < 1) {
            this.commonService.send((CommandSender)player, MessageKey.USAGE_REGISTER);
            return;
        }
        RegistrationType registrationType = this.commonService.getProperty(RegistrationSettings.REGISTRATION_TYPE);
        if (registrationType == RegistrationType.PASSWORD) {
            this.handlePasswordRegistration(player, arguments);
        } else if (registrationType == RegistrationType.EMAIL) {
            this.handleEmailRegistration(player, arguments);
        } else {
            throw new IllegalStateException("Unknown registration type '" + String.valueOf((Object)registrationType) + "'");
        }
    }

    @Override
    protected String getAlternativeCommand() {
        return "/authme register <playername> <password>";
    }

    @Override
    public MessageKey getArgumentsMismatchMessage() {
        return MessageKey.USAGE_REGISTER;
    }

    private boolean isCaptchaFulfilled(Player player) {
        if (this.registrationCaptchaManager.isCaptchaRequired(player.getName())) {
            String code = this.registrationCaptchaManager.getCaptchaCodeOrGenerateNew(player.getName());
            this.commonService.send((CommandSender)player, MessageKey.CAPTCHA_FOR_REGISTRATION_REQUIRED, code);
            return false;
        }
        return true;
    }

    private void handlePasswordRegistration(Player player, List<String> arguments) {
        if (this.isSecondArgValidForPasswordRegistration(player, arguments)) {
            String password = arguments.get(0);
            String email = this.getEmailIfAvailable(arguments);
            this.management.performRegister(RegistrationMethod.PASSWORD_REGISTRATION, PasswordRegisterParams.of(player, password, email));
        }
    }

    private String getEmailIfAvailable(List<String> arguments) {
        RegisterSecondaryArgument secondArgType;
        if (arguments.size() >= 2 && ((secondArgType = this.commonService.getProperty(RegistrationSettings.REGISTER_SECOND_ARGUMENT)) == RegisterSecondaryArgument.EMAIL_MANDATORY || secondArgType == RegisterSecondaryArgument.EMAIL_OPTIONAL)) {
            return arguments.get(1);
        }
        return null;
    }

    private boolean isSecondArgValidForPasswordRegistration(Player player, List<String> arguments) {
        RegisterSecondaryArgument secondArgType = this.commonService.getProperty(RegistrationSettings.REGISTER_SECOND_ARGUMENT);
        if (secondArgType == RegisterSecondaryArgument.NONE || secondArgType == RegisterSecondaryArgument.EMAIL_OPTIONAL && arguments.size() < 2) {
            return true;
        }
        if (arguments.size() < 2) {
            this.commonService.send((CommandSender)player, MessageKey.USAGE_REGISTER);
            return false;
        }
        if (secondArgType == RegisterSecondaryArgument.CONFIRMATION) {
            if (arguments.get(0).equals(arguments.get(1))) {
                return true;
            }
            this.commonService.send((CommandSender)player, MessageKey.PASSWORD_MATCH_ERROR);
            return false;
        }
        if (secondArgType == RegisterSecondaryArgument.EMAIL_MANDATORY || secondArgType == RegisterSecondaryArgument.EMAIL_OPTIONAL) {
            if (this.validationService.validateEmail(arguments.get(1))) {
                return true;
            }
            this.commonService.send((CommandSender)player, MessageKey.INVALID_EMAIL);
            return false;
        }
        throw new IllegalStateException("Unknown secondary argument type '" + String.valueOf((Object)secondArgType) + "'");
    }

    private void handleEmailRegistration(Player player, List<String> arguments) {
        if (!this.emailService.hasAllInformation()) {
            this.commonService.send((CommandSender)player, MessageKey.INCOMPLETE_EMAIL_SETTINGS);
            this.logger.warning("Cannot register player '" + player.getName() + "': no email or password is set to send emails from. Please adjust your config at " + EmailSettings.MAIL_ACCOUNT.getPath());
            return;
        }
        String email = arguments.get(0);
        if (!this.validationService.validateEmail(email)) {
            this.commonService.send((CommandSender)player, MessageKey.INVALID_EMAIL);
        } else if (this.isSecondArgValidForEmailRegistration(player, arguments)) {
            this.management.performRegister(RegistrationMethod.EMAIL_REGISTRATION, EmailRegisterParams.of(player, email));
        }
    }

    private boolean isSecondArgValidForEmailRegistration(Player player, List<String> arguments) {
        RegisterSecondaryArgument secondArgType = this.commonService.getProperty(RegistrationSettings.REGISTER_SECOND_ARGUMENT);
        if (secondArgType == RegisterSecondaryArgument.NONE || secondArgType == RegisterSecondaryArgument.EMAIL_OPTIONAL && arguments.size() < 2) {
            return true;
        }
        if (arguments.size() < 2) {
            this.commonService.send((CommandSender)player, MessageKey.USAGE_REGISTER);
            return false;
        }
        if (secondArgType == RegisterSecondaryArgument.EMAIL_OPTIONAL || secondArgType == RegisterSecondaryArgument.EMAIL_MANDATORY || secondArgType == RegisterSecondaryArgument.CONFIRMATION) {
            if (arguments.get(0).equals(arguments.get(1))) {
                return true;
            }
            this.commonService.send((CommandSender)player, MessageKey.USAGE_REGISTER);
            return false;
        }
        throw new IllegalStateException("Unknown secondary argument type '" + String.valueOf((Object)secondArgType) + "'");
    }
}

