/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.changepassword;

import fr.xephi.authme.command.PlayerCommand;
import fr.xephi.authme.data.VerificationCodeManager;
import fr.xephi.authme.data.auth.PlayerCache;
import fr.xephi.authme.message.MessageKey;
import fr.xephi.authme.process.Management;
import fr.xephi.authme.service.CommonService;
import fr.xephi.authme.service.ValidationService;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ChangePasswordCommand
extends PlayerCommand {
    @Inject
    private CommonService commonService;
    @Inject
    private PlayerCache playerCache;
    @Inject
    private ValidationService validationService;
    @Inject
    private Management management;
    @Inject
    private VerificationCodeManager codeManager;

    @Override
    public void runCommand(Player player, List<String> arguments) {
        String name = player.getName().toLowerCase(Locale.ROOT);
        if (!this.playerCache.isAuthenticated(name)) {
            this.commonService.send((CommandSender)player, MessageKey.NOT_LOGGED_IN);
            return;
        }
        if (this.codeManager.isVerificationRequired(player)) {
            this.codeManager.codeExistOrGenerateNew(name);
            this.commonService.send((CommandSender)player, MessageKey.VERIFICATION_CODE_REQUIRED);
            return;
        }
        String oldPassword = arguments.get(0);
        String newPassword = arguments.get(1);
        ValidationService.ValidationResult passwordValidation = this.validationService.validatePassword(newPassword, name);
        if (passwordValidation.hasError()) {
            this.commonService.send((CommandSender)player, passwordValidation.getMessageKey(), passwordValidation.getArgs());
            return;
        }
        this.management.performPasswordChange(player, oldPassword, newPassword);
    }

    @Override
    protected String getAlternativeCommand() {
        return "/authme password <playername> <password>";
    }

    @Override
    public MessageKey getArgumentsMismatchMessage() {
        return MessageKey.USAGE_CHANGE_PASSWORD;
    }
}

