/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.authme.debug;

import ch.jalu.datasourcecolumns.data.DataSourceValue;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.command.executable.authme.debug.DebugSection;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.mail.SendMailSsl;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.permission.DebugSectionPermissions;
import fr.xephi.authme.permission.PermissionNode;
import fr.xephi.authme.util.StringUtils;
import fr.xephi.authme.util.Utils;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;

class TestEmailSender
implements DebugSection {
    private final ConsoleLogger logger = ConsoleLoggerFactory.get(TestEmailSender.class);
    @Inject
    private DataSource dataSource;
    @Inject
    private SendMailSsl sendMailSsl;
    @Inject
    private Server server;

    TestEmailSender() {
    }

    @Override
    public String getName() {
        return "mail";
    }

    @Override
    public String getDescription() {
        return "Sends out a test email";
    }

    @Override
    public void execute(CommandSender sender, List<String> arguments) {
        sender.sendMessage(String.valueOf(ChatColor.BLUE) + "AuthMe test email sender");
        if (!this.sendMailSsl.hasAllInformation()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You haven't set all required configurations in config.yml for sending emails. Please check your config.yml");
            return;
        }
        String email = this.getEmail(sender, arguments);
        if (email != null) {
            boolean sendMail = this.sendTestEmail(email);
            if (sendMail) {
                sender.sendMessage("Test email sent to " + email + " with success");
            } else {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to send test mail to " + email + "; please check your logs");
            }
        }
    }

    @Override
    public PermissionNode getRequiredPermission() {
        return DebugSectionPermissions.TEST_EMAIL;
    }

    private String getEmail(CommandSender sender, List<String> arguments) {
        if (arguments.isEmpty()) {
            DataSourceValue<String> emailResult = this.dataSource.getEmail(sender.getName());
            if (!emailResult.rowExists()) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Please provide an email address, e.g. /authme debug mail test@example.com");
                return null;
            }
            String email = (String)emailResult.getValue();
            if (Utils.isEmailEmpty(email)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "No email set for your account! Please use /authme debug mail <email>");
                return null;
            }
            return email;
        }
        String email = arguments.get(0);
        if (StringUtils.isInsideString('@', email)) {
            return email;
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid email! Usage: /authme debug mail test@example.com");
        return null;
    }

    private boolean sendTestEmail(String email) {
        HtmlEmail htmlEmail;
        try {
            htmlEmail = this.sendMailSsl.initializeMail(email);
        }
        catch (EmailException e) {
            this.logger.logException("Failed to create email for sample email:", e);
            return false;
        }
        htmlEmail.setSubject("AuthMe test email");
        String message = "Hello there!<br />This is a sample email sent to you from a Minecraft server (" + this.server.getName() + ") via /authme debug mail. If you're seeing this, sending emails should be fine.";
        return this.sendMailSsl.sendEmail(message, htmlEmail);
    }
}

