/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.authme.debug;

import fr.xephi.authme.command.executable.authme.debug.DebugSection;
import fr.xephi.authme.data.limbo.UserGroup;
import fr.xephi.authme.permission.DebugSectionPermissions;
import fr.xephi.authme.permission.PermissionNode;
import fr.xephi.authme.permission.PermissionsManager;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class PermissionGroups
implements DebugSection {
    @Inject
    private PermissionsManager permissionsManager;

    PermissionGroups() {
    }

    @Override
    public String getName() {
        return "groups";
    }

    @Override
    public String getDescription() {
        return "Show permission groups a player belongs to";
    }

    @Override
    public void execute(CommandSender sender, List<String> arguments) {
        sender.sendMessage(String.valueOf(ChatColor.BLUE) + "AuthMe permission groups");
        String name = arguments.isEmpty() ? sender.getName() : arguments.get(0);
        Player player = Bukkit.getPlayer((String)name);
        if (player == null) {
            sender.sendMessage("Player " + name + " could not be found");
        } else {
            List groupNames = this.permissionsManager.getGroups((OfflinePlayer)player).stream().map(UserGroup::getGroupName).collect(Collectors.toList());
            sender.sendMessage("Player " + name + " has permission groups: " + String.join((CharSequence)", ", groupNames));
            sender.sendMessage("Primary group is: " + String.valueOf(this.permissionsManager.getGroups((OfflinePlayer)player)));
        }
    }

    @Override
    public PermissionNode getRequiredPermission() {
        return DebugSectionPermissions.PERM_GROUPS;
    }
}

