/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.authme.debug;

import ch.jalu.configme.properties.Property;
import com.google.common.annotations.VisibleForTesting;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.command.executable.authme.debug.DebugSection;
import fr.xephi.authme.command.executable.authme.debug.DebugSectionUtils;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.datasource.MySQL;
import fr.xephi.authme.datasource.SqlDataSourceUtils;
import fr.xephi.authme.output.ConsoleLoggerFactory;
import fr.xephi.authme.permission.DebugSectionPermissions;
import fr.xephi.authme.permission.PermissionNode;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.DatabaseSettings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

class MySqlDefaultChanger
implements DebugSection {
    private static final String NOT_NULL_SUFFIX = String.valueOf(ChatColor.DARK_AQUA) + "@" + String.valueOf(ChatColor.RESET);
    private static final String DEFAULT_VALUE_SUFFIX = String.valueOf(ChatColor.GOLD) + "#" + String.valueOf(ChatColor.RESET);
    private ConsoleLogger logger = ConsoleLoggerFactory.get(MySqlDefaultChanger.class);
    @Inject
    private Settings settings;
    @Inject
    private DataSource dataSource;
    private MySQL mySql;

    MySqlDefaultChanger() {
    }

    @PostConstruct
    void setMySqlField() {
        this.mySql = DebugSectionUtils.castToTypeOrNull(DebugSectionUtils.unwrapSourceFromCacheDataSource(this.dataSource), MySQL.class);
    }

    @Override
    public String getName() {
        return "mysqldef";
    }

    @Override
    public String getDescription() {
        return "Add or remove the default value of MySQL columns";
    }

    @Override
    public PermissionNode getRequiredPermission() {
        return DebugSectionPermissions.MYSQL_DEFAULT_CHANGER;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(CommandSender sender, List<String> arguments) {
        if (this.mySql == null) {
            sender.sendMessage("Defaults can be changed for the MySQL data source only.");
            return;
        }
        Operation operation = MySqlDefaultChanger.matchToEnum(arguments, 0, Operation.class);
        Columns column = MySqlDefaultChanger.matchToEnum(arguments, 1, Columns.class);
        if (operation == Operation.DETAILS) {
            this.showColumnDetails(sender);
            return;
        }
        if (operation == null || column == null) {
            this.displayUsageHints(sender);
            return;
        }
        sender.sendMessage(String.valueOf(ChatColor.BLUE) + "[AuthMe] MySQL change '" + String.valueOf((Object)column) + "'");
        try (Connection con = this.getConnection(this.mySql);){
            switch (operation) {
                case ADD: {
                    this.changeColumnToNotNullWithDefault(sender, column, con);
                    return;
                }
                case REMOVE: {
                    this.removeNotNullAndDefault(sender, column, con);
                    return;
                }
                default: {
                    throw new IllegalStateException("Unknown operation '" + String.valueOf((Object)operation) + "'");
                }
            }
        }
        catch (IllegalStateException | SQLException e) {
            this.logger.logException("Failed to perform MySQL default altering operation:", e);
        }
    }

    private void changeColumnToNotNullWithDefault(CommandSender sender, Columns column, Connection con) throws SQLException {
        int updatedRows;
        String tableName = (String)this.settings.getProperty(DatabaseSettings.MYSQL_TABLE);
        String columnName = (String)this.settings.getProperty(column.getColumnNameProperty());
        String sql = String.format("UPDATE %s SET %s = ? WHERE %s IS NULL;", tableName, columnName, columnName);
        try (PreparedStatement pst = con.prepareStatement(sql);){
            pst.setObject(1, column.getDefaultValue());
            updatedRows = pst.executeUpdate();
        }
        sender.sendMessage("Replaced NULLs with default value ('" + String.valueOf(column.getDefaultValue()) + "'), modifying " + updatedRows + " entries");
        try (Statement st = con.createStatement();){
            st.execute(String.format("ALTER TABLE %s MODIFY %s %s", tableName, columnName, column.getNotNullDefinition()));
            sender.sendMessage("Changed column '" + columnName + "' to have NOT NULL constraint");
        }
        this.logger.info("Changed MySQL column '" + columnName + "' to be NOT NULL, as initiated by '" + sender.getName() + "'");
    }

    private void removeNotNullAndDefault(CommandSender sender, Columns column, Connection con) throws SQLException {
        int updatedRows;
        String tableName = (String)this.settings.getProperty(DatabaseSettings.MYSQL_TABLE);
        String columnName = (String)this.settings.getProperty(column.getColumnNameProperty());
        try (Statement st = con.createStatement();){
            st.execute(String.format("ALTER TABLE %s MODIFY %s %s", tableName, columnName, column.getNullableDefinition()));
            sender.sendMessage("Changed column '" + columnName + "' to allow nulls");
        }
        String sql = String.format("UPDATE %s SET %s = NULL WHERE %s = ?;", tableName, columnName, columnName);
        try (PreparedStatement pst = con.prepareStatement(sql);){
            pst.setObject(1, column.getDefaultValue());
            updatedRows = pst.executeUpdate();
        }
        sender.sendMessage("Replaced default value ('" + String.valueOf(column.getDefaultValue()) + "') to be NULL, modifying " + updatedRows + " entries");
        this.logger.info("Changed MySQL column '" + columnName + "' to allow NULL, as initiated by '" + sender.getName() + "'");
    }

    private void showColumnDetails(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.BLUE) + "MySQL column details");
        String tableName = (String)this.settings.getProperty(DatabaseSettings.MYSQL_TABLE);
        try (Connection con = this.getConnection(this.mySql);){
            DatabaseMetaData metaData = con.getMetaData();
            for (Columns col : Columns.values()) {
                String columnName = (String)this.settings.getProperty(col.getColumnNameProperty());
                String isNullText = SqlDataSourceUtils.isNotNullColumn(metaData, tableName, columnName) ? "NOT NULL" : "nullable";
                Object defaultValue = SqlDataSourceUtils.getColumnDefaultValue(metaData, tableName, columnName);
                String defaultText = defaultValue == null ? "no default" : "default: '" + String.valueOf(defaultValue) + "'";
                sender.sendMessage(this.formatColumnWithMetadata(col, metaData, tableName) + " (" + columnName + "): " + isNullText + ", " + defaultText);
            }
        }
        catch (SQLException e) {
            this.logger.logException("Failed while showing column details:", e);
            sender.sendMessage("Failed while showing column details. See log for info");
        }
    }

    private void displayUsageHints(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.BLUE) + "MySQL column changer");
        sender.sendMessage("Adds or removes a NOT NULL constraint for a column.");
        sender.sendMessage("Examples: add a NOT NULL constraint with");
        sender.sendMessage(" /authme debug mysqldef add <column>");
        sender.sendMessage("Remove one with /authme debug mysqldef remove <column>");
        sender.sendMessage("Available columns: " + this.constructColumnListWithMetadata());
        sender.sendMessage(" " + NOT_NULL_SUFFIX + ": not-null, " + DEFAULT_VALUE_SUFFIX + ": has default. See /authme debug mysqldef details");
    }

    private String constructColumnListWithMetadata() {
        String string;
        block9: {
            Connection con = this.getConnection(this.mySql);
            try {
                DatabaseMetaData metaData = con.getMetaData();
                String tableName = (String)this.settings.getProperty(DatabaseSettings.MYSQL_TABLE);
                ArrayList<String> formattedColumns = new ArrayList<String>(Columns.values().length);
                for (Columns col : Columns.values()) {
                    formattedColumns.add(this.formatColumnWithMetadata(col, metaData, tableName));
                }
                string = String.join((CharSequence)(String.valueOf(ChatColor.RESET) + ", "), formattedColumns);
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.logger.logException("Failed to construct column list:", e);
                    return String.valueOf(ChatColor.RED) + "An error occurred! Please see the console for details.";
                }
            }
            con.close();
        }
        return string;
    }

    private String formatColumnWithMetadata(Columns column, DatabaseMetaData metaData, String tableName) throws SQLException {
        String columnName = (String)this.settings.getProperty(column.getColumnNameProperty());
        boolean isNotNull = SqlDataSourceUtils.isNotNullColumn(metaData, tableName, columnName);
        boolean hasDefaultValue = SqlDataSourceUtils.getColumnDefaultValue(metaData, tableName, columnName) != null;
        return column.name() + (isNotNull ? NOT_NULL_SUFFIX : "") + (hasDefaultValue ? DEFAULT_VALUE_SUFFIX : "");
    }

    @VisibleForTesting
    Connection getConnection(MySQL mySql) {
        try {
            Method method = MySQL.class.getDeclaredMethod("getConnection", new Class[0]);
            method.setAccessible(true);
            return (Connection)method.invoke((Object)mySql, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Could not get MySQL connection", e);
        }
    }

    private static <E extends Enum<E>> E matchToEnum(List<String> arguments, int index, Class<E> clazz) {
        if (arguments.size() <= index) {
            return null;
        }
        String str = arguments.get(index);
        return (E)((Enum)Arrays.stream((Enum[])clazz.getEnumConstants()).filter(e -> e.name().equalsIgnoreCase(str)).findFirst().orElse(null));
    }

    private static enum Operation {
        ADD,
        REMOVE,
        DETAILS;

    }

    static enum Columns {
        LASTLOGIN(DatabaseSettings.MYSQL_COL_LASTLOGIN, "BIGINT", "BIGINT NOT NULL DEFAULT 0", 0L),
        LASTIP(DatabaseSettings.MYSQL_COL_LAST_IP, "VARCHAR(40) CHARACTER SET ascii COLLATE ascii_bin", "VARCHAR(40) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '127.0.0.1'", "127.0.0.1"),
        EMAIL(DatabaseSettings.MYSQL_COL_EMAIL, "VARCHAR(255)", "VARCHAR(255) NOT NULL DEFAULT 'your@email.com'", "your@email.com");

        private final Property<String> columnNameProperty;
        private final String nullableDefinition;
        private final String notNullDefinition;
        private final Object defaultValue;

        private Columns(Property<String> columnNameProperty, String nullableDefinition, String notNullDefinition, Object defaultValue) {
            this.columnNameProperty = columnNameProperty;
            this.nullableDefinition = nullableDefinition;
            this.notNullDefinition = notNullDefinition;
            this.defaultValue = defaultValue;
        }

        Property<String> getColumnNameProperty() {
            return this.columnNameProperty;
        }

        String getNullableDefinition() {
            return this.nullableDefinition;
        }

        String getNotNullDefinition() {
            return this.notNullDefinition;
        }

        Object getDefaultValue() {
            return this.defaultValue;
        }
    }
}

