/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.authme.debug;

import fr.xephi.authme.command.executable.authme.debug.DebugSection;
import fr.xephi.authme.command.executable.authme.debug.DebugSectionUtils;
import fr.xephi.authme.data.limbo.LimboPlayer;
import fr.xephi.authme.data.limbo.LimboService;
import fr.xephi.authme.data.limbo.persistence.LimboPersistence;
import fr.xephi.authme.permission.DebugSectionPermissions;
import fr.xephi.authme.permission.PermissionNode;
import fr.xephi.authme.permission.PermissionsManager;
import fr.xephi.authme.service.BukkitService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.ServerOperator;

class LimboPlayerViewer
implements DebugSection {
    @Inject
    private LimboService limboService;
    @Inject
    private LimboPersistence limboPersistence;
    @Inject
    private BukkitService bukkitService;
    @Inject
    private PermissionsManager permissionsManager;

    LimboPlayerViewer() {
    }

    @Override
    public String getName() {
        return "limbo";
    }

    @Override
    public String getDescription() {
        return "View LimboPlayers and player's \"limbo stats\"";
    }

    @Override
    public void execute(CommandSender sender, List<String> arguments) {
        LimboPlayer diskLimbo;
        if (arguments.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.BLUE) + "AuthMe limbo viewer");
            sender.sendMessage("/authme debug limbo <player>: show a player's limbo info");
            sender.sendMessage("Available limbo records: " + String.valueOf(DebugSectionUtils.applyToLimboPlayersMap(this.limboService, Map::keySet)));
            return;
        }
        LimboPlayer memoryLimbo = this.limboService.getLimboPlayer(arguments.get(0));
        Player player = this.bukkitService.getPlayerExact(arguments.get(0));
        LimboPlayer limboPlayer = diskLimbo = player != null ? this.limboPersistence.getLimboPlayer(player) : null;
        if (memoryLimbo == null && player == null) {
            sender.sendMessage(String.valueOf(ChatColor.BLUE) + "No AuthMe limbo data");
            sender.sendMessage("No limbo data and no player online with name '" + arguments.get(0) + "'");
            return;
        }
        sender.sendMessage(String.valueOf(ChatColor.BLUE) + "Player / limbo / disk limbo info for '" + arguments.get(0) + "'");
        new InfoDisplayer(sender, player, memoryLimbo, diskLimbo).sendEntry("Is op", ServerOperator::isOp, LimboPlayer::isOperator).sendEntry("Walk speed", Player::getWalkSpeed, LimboPlayer::getWalkSpeed).sendEntry("Can fly", Player::getAllowFlight, LimboPlayer::isCanFly).sendEntry("Fly speed", Player::getFlySpeed, LimboPlayer::getFlySpeed).sendEntry("Location", p -> DebugSectionUtils.formatLocation(p.getLocation()), l -> DebugSectionUtils.formatLocation(l.getLocation())).sendEntry("Prim. group", p -> this.permissionsManager.hasGroupSupport() ? this.permissionsManager.getPrimaryGroup((OfflinePlayer)p) : "N/A", LimboPlayer::getGroups);
    }

    @Override
    public PermissionNode getRequiredPermission() {
        return DebugSectionPermissions.LIMBO_PLAYER_VIEWER;
    }

    private static final class InfoDisplayer {
        private final CommandSender sender;
        private final Optional<Player> player;
        private final Optional<LimboPlayer> memoryLimbo;
        private final Optional<LimboPlayer> diskLimbo;

        InfoDisplayer(CommandSender sender, Player player, LimboPlayer memoryLimbo, LimboPlayer diskLimbo) {
            this.sender = sender;
            this.player = Optional.ofNullable(player);
            this.memoryLimbo = Optional.ofNullable(memoryLimbo);
            this.diskLimbo = Optional.ofNullable(diskLimbo);
            if (memoryLimbo == null) {
                sender.sendMessage("Note: no Limbo information available");
            }
            if (player == null) {
                sender.sendMessage("Note: player is not online");
            } else if (diskLimbo == null) {
                sender.sendMessage("Note: no Limbo on disk available");
            }
        }

        <T> InfoDisplayer sendEntry(String title, Function<Player, T> playerGetter, Function<LimboPlayer, T> limboGetter) {
            this.sender.sendMessage(title + ": " + InfoDisplayer.getData(this.player, playerGetter) + " / " + InfoDisplayer.getData(this.memoryLimbo, limboGetter) + " / " + InfoDisplayer.getData(this.diskLimbo, limboGetter));
            return this;
        }

        static <E, T> String getData(Optional<E> entity, Function<E, T> getter) {
            return entity.map(getter).map(String::valueOf).orElse(" -- ");
        }
    }
}

