/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.authme.debug;

import fr.xephi.authme.command.executable.authme.debug.DebugSection;
import fr.xephi.authme.listener.FailedVerificationException;
import fr.xephi.authme.listener.OnJoinVerifier;
import fr.xephi.authme.message.Messages;
import fr.xephi.authme.permission.DebugSectionPermissions;
import fr.xephi.authme.permission.PermissionNode;
import fr.xephi.authme.service.ValidationService;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

class InputValidator
implements DebugSection {
    @Inject
    private ValidationService validationService;
    @Inject
    private Messages messages;
    @Inject
    private OnJoinVerifier onJoinVerifier;

    InputValidator() {
    }

    @Override
    public String getName() {
        return "valid";
    }

    @Override
    public String getDescription() {
        return "Checks if your config.yml allows a password / email";
    }

    @Override
    public void execute(CommandSender sender, List<String> arguments) {
        if (arguments.size() < 2 || !ValidationObject.matchesAny(arguments.get(0))) {
            this.displayUsageHint(sender);
        } else if (ValidationObject.PASS.matches(arguments.get(0))) {
            this.validatePassword(sender, arguments.get(1));
        } else if (ValidationObject.MAIL.matches(arguments.get(0))) {
            this.validateEmail(sender, arguments.get(1));
        } else if (ValidationObject.NAME.matches(arguments.get(0))) {
            this.validateUsername(sender, arguments.get(1));
        } else {
            throw new IllegalStateException("Unexpected validation object with arg[0] = '" + arguments.get(0) + "'");
        }
    }

    @Override
    public PermissionNode getRequiredPermission() {
        return DebugSectionPermissions.INPUT_VALIDATOR;
    }

    private void displayUsageHint(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.BLUE) + "Validation tests");
        sender.sendMessage("You can define forbidden emails and passwords in your config.yml. You can test your settings with this command.");
        String command = String.valueOf(ChatColor.GOLD) + "/authme debug valid";
        sender.sendMessage(" Use " + command + " pass <pass>" + String.valueOf(ChatColor.RESET) + " to check a password");
        sender.sendMessage(" Use " + command + " mail <mail>" + String.valueOf(ChatColor.RESET) + " to check an email");
        sender.sendMessage(" Use " + command + " name <name>" + String.valueOf(ChatColor.RESET) + " to check a username");
    }

    private void validatePassword(CommandSender sender, String password) {
        ValidationService.ValidationResult validationResult = this.validationService.validatePassword(password, "");
        sender.sendMessage(String.valueOf(ChatColor.BLUE) + "Validation of password '" + password + "'");
        if (validationResult.hasError()) {
            this.messages.send(sender, validationResult.getMessageKey(), validationResult.getArgs());
        } else {
            sender.sendMessage(String.valueOf(ChatColor.DARK_GREEN) + "Valid password!");
        }
    }

    private void validateEmail(CommandSender sender, String email) {
        boolean isValidEmail = this.validationService.validateEmail(email);
        sender.sendMessage(String.valueOf(ChatColor.BLUE) + "Validation of email '" + email + "'");
        if (isValidEmail) {
            sender.sendMessage(String.valueOf(ChatColor.DARK_GREEN) + "Valid email!");
        } else {
            sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + "Email is not valid!");
        }
    }

    private void validateUsername(CommandSender sender, String username) {
        sender.sendMessage(String.valueOf(ChatColor.BLUE) + "Validation of username '" + username + "'");
        try {
            this.onJoinVerifier.checkIsValidName(username);
            sender.sendMessage("Valid username!");
        }
        catch (FailedVerificationException failedVerificationEx) {
            this.messages.send(sender, failedVerificationEx.getReason(), failedVerificationEx.getArgs());
        }
    }

    static enum ValidationObject {
        PASS,
        MAIL,
        NAME;


        static boolean matchesAny(String arg) {
            return Arrays.stream(ValidationObject.values()).anyMatch(vo -> vo.matches(arg));
        }

        boolean matches(String arg) {
            return this.name().equalsIgnoreCase(arg);
        }
    }
}

