/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.authme.debug;

import com.google.common.collect.ImmutableList;
import fr.xephi.authme.command.executable.authme.debug.DebugSection;
import fr.xephi.authme.permission.AdminPermission;
import fr.xephi.authme.permission.DebugSectionPermissions;
import fr.xephi.authme.permission.DefaultPermission;
import fr.xephi.authme.permission.PermissionNode;
import fr.xephi.authme.permission.PermissionsManager;
import fr.xephi.authme.permission.PlayerPermission;
import fr.xephi.authme.permission.PlayerStatePermission;
import fr.xephi.authme.service.BukkitService;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.inject.Inject;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class HasPermissionChecker
implements DebugSection {
    static final List<Class<? extends PermissionNode>> PERMISSION_NODE_CLASSES = ImmutableList.of(AdminPermission.class, PlayerPermission.class, PlayerStatePermission.class, DebugSectionPermissions.class);
    @Inject
    private PermissionsManager permissionsManager;
    @Inject
    private BukkitService bukkitService;

    HasPermissionChecker() {
    }

    @Override
    public String getName() {
        return "perm";
    }

    @Override
    public String getDescription() {
        return "Checks if a player has a given permission";
    }

    @Override
    public void execute(CommandSender sender, List<String> arguments) {
        sender.sendMessage(String.valueOf(ChatColor.BLUE) + "AuthMe permission check");
        if (arguments.size() < 2) {
            sender.sendMessage("Check if a player has permission:");
            sender.sendMessage("Example: /authme debug perm bobby my.perm.node");
            sender.sendMessage("Permission system type used: " + String.valueOf((Object)this.permissionsManager.getPermissionSystem()));
            return;
        }
        String playerName = arguments.get(0);
        String permissionNode = arguments.get(1);
        Player player = this.bukkitService.getPlayerExact(playerName);
        if (player == null) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)playerName);
            if (offlinePlayer == null) {
                sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + "Player '" + playerName + "' does not exist");
            } else {
                sender.sendMessage("Player '" + playerName + "' not online; checking with offline player");
                HasPermissionChecker.performPermissionCheck(offlinePlayer, permissionNode, this.permissionsManager::hasPermissionOffline, sender);
            }
        } else {
            HasPermissionChecker.performPermissionCheck(player, permissionNode, this.permissionsManager::hasPermission, sender);
        }
    }

    @Override
    public PermissionNode getRequiredPermission() {
        return DebugSectionPermissions.HAS_PERMISSION_CHECK;
    }

    private static <P extends OfflinePlayer> void performPermissionCheck(P player, String node, BiFunction<P, PermissionNode, Boolean> permissionChecker, CommandSender sender) {
        PermissionNode permNode = HasPermissionChecker.getPermissionNode(sender, node);
        if (permissionChecker.apply(player, permNode).booleanValue()) {
            sender.sendMessage(String.valueOf(ChatColor.DARK_GREEN) + "Success: player '" + player.getName() + "' has permission '" + node + "'");
        } else {
            sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + "Check failed: player '" + player.getName() + "' does NOT have permission '" + node + "'");
        }
    }

    private static PermissionNode getPermissionNode(CommandSender sender, String node) {
        Optional<PermissionNode> permNode = PERMISSION_NODE_CLASSES.stream().map(Class::getEnumConstants).flatMap(Arrays::stream).filter(perm -> perm.getNode().equals(node)).findFirst();
        if (permNode.isPresent()) {
            return permNode.get();
        }
        sender.sendMessage("Did not detect AuthMe permission; using default permission = DENIED");
        return HasPermissionChecker.createPermNode(node);
    }

    private static PermissionNode createPermNode(final String node) {
        return new PermissionNode(){

            @Override
            public String getNode() {
                return node;
            }

            @Override
            public DefaultPermission getDefaultPermission() {
                return DefaultPermission.NOT_ALLOWED;
            }
        };
    }
}

